/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.changes.issues.Issue;

public class IssueUtils {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static List<Issue> filterIssuesWithVersionPrefix(List<Issue> issues, String prefix) throws MojoExecutionException {
        ArrayList<Issue> filteredIssues = new ArrayList<Issue>();
        boolean isFound = false;
        block0: for (Issue issue1 : issues) {
            Issue issue = issue1;
            if (issue.getFixVersions() == null) continue;
            for (String fixVersion : issue.getFixVersions()) {
                if (prefix != null && !fixVersion.startsWith(prefix)) continue;
                isFound = true;
                filteredIssues.add(issue);
                continue block0;
            }
        }
        if (!isFound) {
            throw new MojoExecutionException("Couldn't find any issues with a Fix Version prefix of '" + prefix + "' among the supplied issues: " + IssueUtils.toString(issues));
        }
        return filteredIssues;
    }

    public static List<Issue> getIssuesForVersion(List<Issue> issues, String version) {
        ArrayList<Issue> issuesForVersion = new ArrayList<Issue>();
        String releaseVersion = version;
        if (version != null && version.endsWith(SNAPSHOT_SUFFIX)) {
            releaseVersion = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        for (Issue issue : issues) {
            if (issue.getFixVersions() == null || !issue.getFixVersions().contains(releaseVersion)) continue;
            issuesForVersion.add(issue);
        }
        return issuesForVersion;
    }

    public static String toString(List<Issue> issues) {
        ArrayList<String> issueStrings = new ArrayList<String>(issues.size());
        for (Issue issue : issues) {
            issueStrings.add(issue.toString());
        }
        return ((Object)issueStrings).toString();
    }
}

