/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Release;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseUtils {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final Logger LOG = LoggerFactory.getLogger(ReleaseUtils.class);

    private ReleaseUtils() {
    }

    public static Release getLatestRelease(List<Release> releases, String pomVersion) throws MojoExecutionException {
        if (pomVersion != null && pomVersion.endsWith(SNAPSHOT_SUFFIX)) {
            pomVersion = pomVersion.substring(0, pomVersion.length() - SNAPSHOT_SUFFIX.length());
        }
        LOG.debug("Found {} releases.", (Object)releases.size());
        Release release = ReleaseUtils.getRelease(releases, pomVersion);
        if (release == null) {
            throw new MojoExecutionException("Couldn't find the release '" + pomVersion + "' among the supplied releases: " + ReleaseUtils.toString(releases));
        }
        return release;
    }

    protected static Release getRelease(List<Release> releases, String version) {
        for (Release release : releases) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The release: {} has {} actions.", (Object)release.getVersion(), (Object)release.getActions().size());
            }
            if (release.getVersion() == null || !release.getVersion().equals(version)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found the correct release: {}", (Object)release.getVersion());
                ReleaseUtils.logRelease(release);
            }
            return release;
        }
        return null;
    }

    protected static void logRelease(Release release) {
        Iterator<Action> iterator = release.getActions().iterator();
        while (iterator.hasNext()) {
            Action action1;
            Action action = action1 = iterator.next();
            LOG.debug("o {}", (Object)action.getType());
            LOG.debug("issue: {}", (Object)action.getIssue());
            LOG.debug("action: {}", (Object)action.getAction());
            LOG.debug("dueTo: {}", (Object)action.getDueTo());
        }
    }

    public static List<Release> mergeReleases(List<Release> firstReleases, List<Release> secondReleases) {
        if (firstReleases == null && secondReleases == null) {
            return Collections.emptyList();
        }
        if (firstReleases == null) {
            return secondReleases;
        }
        if (secondReleases == null) {
            return firstReleases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        for (Release firstRelease : firstReleases) {
            Release secondRelease = ReleaseUtils.getRelease(secondReleases, firstRelease.getVersion());
            if (secondRelease != null && secondRelease.getActions() != null) {
                firstRelease.getActions().addAll(secondRelease.getActions());
            }
            mergedReleases.add(firstRelease);
        }
        for (Release secondRelease : secondReleases) {
            Release mergedRelease = ReleaseUtils.getRelease(mergedReleases, secondRelease.getVersion());
            if (mergedRelease != null) continue;
            mergedReleases.add(secondRelease);
        }
        return mergedReleases;
    }

    public static List<Release> mergeReleases(List<Release> releases, String componentName, List<Release> componentReleases) {
        if (releases == null && componentReleases == null) {
            return Collections.emptyList();
        }
        if (componentReleases == null) {
            return releases;
        }
        ArrayList<Release> mergedReleases = new ArrayList<Release>();
        if (releases != null) {
            for (Release release : releases) {
                Release componentRelease = ReleaseUtils.getRelease(componentReleases, release.getVersion());
                if (componentRelease != null) {
                    release.addComponent(componentName, componentRelease);
                }
                mergedReleases.add(release);
            }
        }
        for (Release release : componentReleases) {
            Release mergedRelease = ReleaseUtils.getRelease(mergedReleases, release.getVersion());
            if (mergedRelease != null) continue;
            Release componentRelease = new Release();
            componentRelease.setVersion(release.getVersion());
            componentRelease.setDateRelease(release.getDateRelease());
            componentRelease.addComponent(componentName, release);
            mergedReleases.add(componentRelease);
        }
        return mergedReleases;
    }

    private static String toString(Release release) {
        return release.getClass().getSimpleName() + "[version='" + release.getVersion() + "', date='" + release.getDateRelease() + "', description='" + release.getDescription() + "', actionsSize=" + release.getActions().size() + "]";
    }

    public static String toString(List<Release> releases) {
        ArrayList<String> releaseStrings = new ArrayList<String>(releases.size());
        for (Release release : releases) {
            releaseStrings.add(ReleaseUtils.toString(release));
        }
        return ((Object)releaseStrings).toString();
    }
}

