/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesMojo;
import org.apache.maven.plugins.changes.schema.ChangesSchemaValidator;
import org.apache.maven.plugins.changes.schema.SchemaValidatorException;
import org.apache.maven.plugins.changes.schema.XmlValidationHandler;
import org.xml.sax.SAXParseException;

@Mojo(name="changes-validate", threadSafe=true)
public class ChangesValidatorMojo
extends AbstractChangesMojo {
    @Parameter(property="changes.xsdVersion", defaultValue="2.0.0")
    private String changesXsdVersion;
    @Parameter(property="changes.validate.failed", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="changes.xmlPath", defaultValue="src/changes/changes.xml")
    private File xmlPath;
    private ChangesSchemaValidator changesSchemaValidator;

    @Inject
    public ChangesValidatorMojo(ChangesSchemaValidator changesSchemaValidator) {
        this.changesSchemaValidator = changesSchemaValidator;
    }

    public void execute() throws MojoExecutionException {
        block7: {
            if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
                this.getLog().info((CharSequence)"Skipping the changes validate in this project because it's not the Execution Root");
            } else {
                if (!this.xmlPath.exists()) {
                    this.getLog().warn((CharSequence)("changes.xml file " + this.xmlPath.getAbsolutePath() + " does not exist."));
                    return;
                }
                try {
                    boolean hasErrors;
                    XmlValidationHandler xmlValidationHandler = this.changesSchemaValidator.validateXmlWithSchema(this.xmlPath, this.changesXsdVersion, this.failOnError);
                    boolean bl = hasErrors = !xmlValidationHandler.getErrors().isEmpty();
                    if (hasErrors) {
                        this.logSchemaValidation(xmlValidationHandler.getErrors());
                        if (this.failOnError) {
                            throw new MojoExecutionException("changes.xml file " + this.xmlPath.getAbsolutePath() + " is not valid. See previous errors.");
                        }
                        this.getLog().info((CharSequence)" skip previous validation errors due to failOnError=false.");
                    }
                }
                catch (SchemaValidatorException e) {
                    if (!this.failOnError) break block7;
                    throw new MojoExecutionException("changes.xml file is not valid: " + this.xmlPath.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
                }
            }
        }
    }

    private void logSchemaValidation(List<SAXParseException> errors) {
        this.getLog().warn((CharSequence)("changes.xml file is not valid: " + this.xmlPath.getAbsolutePath()));
        this.getLog().warn((CharSequence)"validation errors: ");
        for (SAXParseException error : errors) {
            this.getLog().warn((CharSequence)error.getMessage());
        }
    }
}

