/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.plugins.changes.ChangesXML;
import org.apache.maven.plugins.changes.issues.AbstractIssuesReportRenderer;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Component;
import org.apache.maven.plugins.changes.model.DueTo;
import org.apache.maven.plugins.changes.model.Release;

public class ChangesReportRenderer
extends AbstractIssuesReportRenderer {
    private static final String URL_TOKEN = "%URL%";
    private static final String ISSUE_TOKEN = "%ISSUE%";
    static final String DEFAULT_ISSUE_SYSTEM_KEY = "default";
    private static final String NO_TEAM = "none";
    private final ChangesXML changesXML;
    private String system;
    private String team;
    private String url;
    private Map<String, String> issueLinksPerSystem = new HashMap<String, String>();
    private boolean addActionDate;
    private boolean linkToFeed;
    private boolean escapeText;

    public ChangesReportRenderer(Sink sink, ResourceBundle bundleName, ChangesXML changesXML) {
        super(sink, bundleName);
        this.changesXML = changesXML;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIssueLinksPerSystem(Map<String, String> issueLinksPerSystem) {
        if (this.issueLinksPerSystem != null && issueLinksPerSystem == null) {
            return;
        }
        this.issueLinksPerSystem = issueLinksPerSystem;
    }

    public void setAddActionDate(boolean addActionDate) {
        this.addActionDate = addActionDate;
    }

    public void setLinkToFeed(boolean generateLinkTofeed) {
        this.linkToFeed = generateLinkTofeed;
    }

    public void setEscapeText(boolean escapeText) {
        this.escapeText = escapeText;
    }

    private boolean canGenerateIssueLinks(String system) {
        if (!this.issueLinksPerSystem.containsKey(system)) {
            return false;
        }
        String issueLink = this.issueLinksPerSystem.get(system);
        if (StringUtils.isBlank((CharSequence)issueLink)) {
            return false;
        }
        return !issueLink.contains(URL_TOKEN) || !StringUtils.isBlank((CharSequence)this.url);
    }

    protected void renderBody() {
        this.constructReleaseHistory();
        this.constructReleases();
    }

    @Override
    public String getTitle() {
        String title = this.changesXML.getTitle();
        if (title == null) {
            title = this.bundle.getString("report.issues.header");
        }
        return title;
    }

    private void constructAction(Action action) {
        this.sink.tableRow();
        this.sinkShowTypeIcon(action.getType());
        this.sink.tableCell();
        String actionDescription = action.getAction();
        if (this.escapeText || StringUtils.isEmpty((CharSequence)actionDescription)) {
            this.text(actionDescription);
        } else {
            this.sink.rawText(actionDescription);
        }
        if (StringUtils.isNotEmpty((CharSequence)action.getIssue()) || !action.getFixedIssues().isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)actionDescription) && !actionDescription.endsWith(".")) {
                this.text(".");
            }
            this.text(" " + this.bundle.getString("report.changes.text.fixes") + " ");
            String system = action.getSystem();
            if (StringUtils.isEmpty((CharSequence)system)) {
                system = this.system;
            }
            if (StringUtils.isEmpty((CharSequence)system)) {
                system = DEFAULT_ISSUE_SYSTEM_KEY;
            }
            if (!this.canGenerateIssueLinks(system)) {
                this.constructIssueText(action.getIssue(), action.getFixedIssues());
            } else {
                this.constructIssueLink(action.getIssue(), system, action.getFixedIssues());
            }
            this.text(".");
        }
        if (!action.getDueTos().isEmpty()) {
            this.constructDueTo(action);
        }
        this.sink.tableCell_();
        if (NO_TEAM.equals(this.team) || action.getDev() == null || action.getDev().isEmpty()) {
            this.sinkCell(action.getDev());
        } else {
            this.sinkCellLink(action.getDev(), this.team + "#" + action.getDev());
        }
        if (this.addActionDate) {
            this.sinkCell(action.getDate());
        }
        this.sink.tableRow_();
    }

    private void constructDueTo(Action action) {
        this.text(" " + this.bundle.getString("report.changes.text.thanx") + " ");
        int i = 0;
        for (DueTo dueTo : action.getDueTos()) {
            ++i;
            if (StringUtils.isNotEmpty((CharSequence)dueTo.getEmail())) {
                String text = dueTo.getName();
                this.link("mailto:" + dueTo.getEmail(), text);
            } else {
                this.text(dueTo.getName());
            }
            if (i >= action.getDueTos().size()) continue;
            this.text(", ");
        }
        this.text(".");
    }

    private void constructIssueLink(String issue, String system, List<String> fixes) {
        if (StringUtils.isNotEmpty((CharSequence)issue)) {
            this.link(this.parseIssueLink(issue, system), issue);
            if (!fixes.isEmpty()) {
                this.text(", ");
            }
        }
        Iterator<String> iterator = fixes.iterator();
        while (iterator.hasNext()) {
            String currentIssueId = iterator.next();
            if (StringUtils.isNotEmpty((CharSequence)currentIssueId)) {
                this.link(this.parseIssueLink(currentIssueId, system), currentIssueId);
            }
            if (!iterator.hasNext()) continue;
            this.text(", ");
        }
    }

    private void constructIssueText(String issue, List<String> fixes) {
        if (StringUtils.isNotEmpty((CharSequence)issue)) {
            this.text(issue);
            if (!fixes.isEmpty()) {
                this.text(", ");
            }
        }
        Iterator<String> iterator = fixes.iterator();
        while (iterator.hasNext()) {
            String currentIssueId = iterator.next();
            if (StringUtils.isNotEmpty((CharSequence)currentIssueId)) {
                this.text(currentIssueId);
            }
            if (!iterator.hasNext()) continue;
            this.text(", ");
        }
    }

    private void constructReleaseHistory() {
        this.startSection(this.bundle.getString("report.changes.label.releasehistory"));
        this.startTable();
        this.tableHeader(new String[]{this.bundle.getString("report.issues.label.fixVersion"), this.bundle.getString("report.changes.label.releaseDate"), this.bundle.getString("report.changes.label.releaseDescription")});
        for (Release release : this.changesXML.getReleaseList()) {
            this.sink.tableRow();
            this.sinkCellLink(release.getVersion(), "#" + DoxiaUtils.encodeId((String)release.getVersion()));
            this.sinkCell(release.getDateRelease());
            this.sinkCell(release.getDescription());
            this.sink.tableRow_();
        }
        this.endTable();
        if (this.linkToFeed) {
            this.sink.paragraph();
            this.text(this.bundle.getString("report.changes.text.rssfeed"));
            this.sink.nonBreakingSpace();
            this.sink.link("changes.rss");
            this.sinkFigure("images/rss.png", "rss feed");
            this.sink.link_();
            this.sink.paragraph_();
        }
        this.endSection();
    }

    private void constructReleases() {
        for (Release release : this.changesXML.getReleaseList()) {
            this.constructRelease(release);
        }
    }

    private void constructRelease(Release release) {
        String date = release.getDateRelease() == null ? "" : " \u2013 " + release.getDateRelease();
        this.startSection(this.bundle.getString("report.changes.label.release") + " " + release.getVersion() + date, DoxiaUtils.encodeId((String)release.getVersion()));
        if (this.isReleaseEmpty(release)) {
            this.sink.paragraph();
            this.text(this.bundle.getString("report.changes.text.no.changes"));
            this.sink.paragraph_();
        } else {
            this.startTable();
            this.sink.tableRow();
            this.tableHeaderCell(this.bundle.getString("report.issues.label.type"));
            this.tableHeaderCell(this.bundle.getString("report.issues.label.summary"));
            this.tableHeaderCell(this.bundle.getString("report.issues.label.assignee"));
            if (this.addActionDate) {
                this.tableHeaderCell(this.bundle.getString("report.issues.label.updated"));
            }
            this.sink.tableRow_();
            for (Action action : release.getActions()) {
                this.constructAction(action);
            }
            for (Component component : release.getComponents()) {
                this.constructComponent(component);
            }
            this.endTable();
        }
        this.endSection();
    }

    private void constructComponent(Component component) {
        if (!component.getActions().isEmpty()) {
            this.sink.tableRow();
            this.sink.tableHeaderCell();
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.text(component.getName());
            this.sink.tableHeaderCell_();
            this.sink.tableHeaderCell();
            this.sink.tableHeaderCell_();
            if (this.addActionDate) {
                this.sink.tableHeaderCell();
                this.sink.tableHeaderCell_();
            }
            this.sink.tableRow_();
            for (Action action : component.getActions()) {
                this.constructAction(action);
            }
        }
    }

    private boolean isReleaseEmpty(Release release) {
        if (!release.getActions().isEmpty()) {
            return false;
        }
        for (Component component : release.getComponents()) {
            if (component.getActions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private String parseIssueLink(String issue, String system) {
        String issueLink = this.issueLinksPerSystem.get(system);
        String parseLink = issueLink.replaceFirst(ISSUE_TOKEN, issue);
        if (parseLink.contains(URL_TOKEN)) {
            String url = this.url.substring(0, this.url.lastIndexOf("/"));
            parseLink = parseLink.replaceFirst(URL_TOKEN, url);
        }
        return parseLink;
    }
}

