/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.javadoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.maven.settings.Settings;
import org.apache.maven.tools.plugin.javadoc.FullyQualifiedJavadocReference;
import org.apache.maven.tools.plugin.javadoc.JavadocSite;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavadocLinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JavadocLinkGenerator.class);
    private final List<JavadocSite> externalJavadocSites;
    private final JavadocSite internalJavadocSite;

    public JavadocLinkGenerator(URI internalJavadocSiteUrl, String internalJavadocVersion) {
        this(internalJavadocSiteUrl, internalJavadocVersion, Collections.emptyList(), null);
    }

    public JavadocLinkGenerator(List<URI> externalJavadocSiteUrls, Settings settings) {
        this(null, null, externalJavadocSiteUrls, settings);
    }

    public JavadocLinkGenerator(URI internalJavadocSiteUrl, String internalJavadocVersion, List<URI> externalJavadocSiteUrls, Settings settings) {
        if (internalJavadocSiteUrl != null) {
            JavaVersion javadocVersion = JavaVersion.parse((String)internalJavadocVersion);
            this.internalJavadocSite = new JavadocSite(internalJavadocSiteUrl, JavadocToolVersionRange.findMatch(javadocVersion), false);
        } else {
            this.internalJavadocSite = null;
        }
        if (externalJavadocSiteUrls != null) {
            this.externalJavadocSites = new ArrayList<JavadocSite>(externalJavadocSiteUrls.size());
            for (URI siteUrl : externalJavadocSiteUrls) {
                try {
                    this.externalJavadocSites.add(new JavadocSite(siteUrl, settings));
                }
                catch (IOException e) {
                    LOG.warn("Could not use {} as base URL: {}", new Object[]{siteUrl, e.getMessage(), e});
                }
            }
        } else {
            this.externalJavadocSites = Collections.emptyList();
        }
        if (this.internalJavadocSite == null && this.externalJavadocSites.isEmpty()) {
            throw new IllegalArgumentException("Either internal or at least one accessible external javadoc URLs must be given!");
        }
    }

    public URI createLink(FullyQualifiedJavadocReference javadocReference) {
        if (!javadocReference.isExternal() && this.internalJavadocSite != null) {
            return this.internalJavadocSite.createLink(javadocReference);
        }
        JavadocSite javadocSite = this.externalJavadocSites.stream().filter(base -> base.hasEntryFor(javadocReference.getModuleName(), javadocReference.getPackageName())).findFirst().orElseThrow(() -> new IllegalArgumentException("Found no javadoc site for " + javadocReference));
        return javadocSite.createLink(javadocReference);
    }

    public URI createLink(String binaryName) {
        Map.Entry<String, String> packageAndClassName = JavadocSite.getPackageAndClassName(binaryName);
        JavadocSite javadocSite = this.externalJavadocSites.stream().filter(base -> base.hasEntryFor(Optional.empty(), Optional.of((String)packageAndClassName.getKey()))).findFirst().orElse(null);
        if (javadocSite == null) {
            if (this.internalJavadocSite != null) {
                javadocSite = this.internalJavadocSite;
            } else {
                throw new IllegalArgumentException("Found no javadoc site for " + binaryName);
            }
        }
        return javadocSite.createLink(packageAndClassName.getKey(), packageAndClassName.getValue());
    }

    public URI getInternalJavadocSiteBaseUrl() {
        if (this.internalJavadocSite == null) {
            throw new IllegalStateException("Could not get docroot of internal javadoc as it hasn't been set");
        }
        return this.internalJavadocSite.getBaseUri();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLinkValid(URI url, Path baseDirectory) {
        if (!url.isAbsolute()) {
            Path file = baseDirectory.resolve(url.getPath());
            boolean exists = Files.exists(file, new LinkOption[0]);
            if (exists) return exists;
            LOG.debug("Could not find file given through '{}' in resolved path '{}'", (Object)url, (Object)file);
            return exists;
        }
        try (BufferedReader reader = JavadocSite.getReader(url.toURL(), null);){
            if (url.getFragment() == null) return true;
            Pattern pattern = JavadocSite.getAnchorPattern(url.getFragment());
            if (!reader.lines().noneMatch(pattern.asPredicate())) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static enum JavadocToolVersionRange {
        JDK7_OR_LOWER(null, JavaVersion.parse((String)"1.8")),
        JDK8_OR_9(JavaVersion.parse((String)"1.8"), JavaVersion.parse((String)"10")),
        JDK10_OR_HIGHER(JavaVersion.parse((String)"10"), null);

        private final JavaVersion lowerBound;
        private final JavaVersion upperBound;

        private JavadocToolVersionRange(JavaVersion lowerBound, JavaVersion upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        static JavadocToolVersionRange findMatch(JavaVersion javadocVersion) {
            for (JavadocToolVersionRange range : JavadocToolVersionRange.values()) {
                if (range.lowerBound != null && !javadocVersion.isAtLeast(range.lowerBound) || range.upperBound != null && !javadocVersion.isBefore(range.upperBound)) continue;
                return range;
            }
            throw new IllegalArgumentException("Found no matching javadoc tool version range for " + javadocVersion);
        }
    }
}

