/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix.tree;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.spatial.prefix.tree.Node;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;

public class QuadPrefixTree
extends SpatialPrefixTree {
    public static final int MAX_LEVELS_POSSIBLE = 50;
    public static final int DEFAULT_MAX_LEVELS = 12;
    private final double xmin;
    private final double xmax;
    private final double ymin;
    private final double ymax;
    private final double xmid;
    private final double ymid;
    private final double gridW;
    public final double gridH;
    final double[] levelW;
    final double[] levelH;
    final int[] levelS;
    final int[] levelN;

    public QuadPrefixTree(SpatialContext ctx, Rectangle bounds, int maxLevels) {
        super(ctx, maxLevels);
        this.xmin = bounds.getMinX();
        this.xmax = bounds.getMaxX();
        this.ymin = bounds.getMinY();
        this.ymax = bounds.getMaxY();
        this.levelW = new double[maxLevels];
        this.levelH = new double[maxLevels];
        this.levelS = new int[maxLevels];
        this.levelN = new int[maxLevels];
        this.gridW = this.xmax - this.xmin;
        this.gridH = this.ymax - this.ymin;
        this.xmid = this.xmin + this.gridW / 2.0;
        this.ymid = this.ymin + this.gridH / 2.0;
        this.levelW[0] = this.gridW / 2.0;
        this.levelH[0] = this.gridH / 2.0;
        this.levelS[0] = 2;
        this.levelN[0] = 4;
        for (int i = 1; i < this.levelW.length; ++i) {
            this.levelW[i] = this.levelW[i - 1] / 2.0;
            this.levelH[i] = this.levelH[i - 1] / 2.0;
            this.levelS[i] = this.levelS[i - 1] * 2;
            this.levelN[i] = this.levelN[i - 1] * 4;
        }
    }

    public QuadPrefixTree(SpatialContext ctx) {
        this(ctx, 12);
    }

    public QuadPrefixTree(SpatialContext ctx, int maxLevels) {
        this(ctx, ctx.getWorldBounds(), maxLevels);
    }

    public void printInfo(PrintStream out) {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
        nf.setMaximumFractionDigits(5);
        nf.setMinimumFractionDigits(5);
        nf.setMinimumIntegerDigits(3);
        for (int i = 0; i < this.maxLevels; ++i) {
            out.println(i + "]\t" + nf.format(this.levelW[i]) + "\t" + nf.format(this.levelH[i]) + "\t" + this.levelS[i] + "\t" + this.levelS[i] * this.levelS[i]);
        }
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        for (int i = 0; i < this.maxLevels - 1; ++i) {
            if (!(dist > this.levelW[i]) || !(dist > this.levelH[i])) continue;
            return i + 1;
        }
        return this.maxLevels;
    }

    @Override
    public Node getNode(Point p, int level) {
        ArrayList<Node> cells = new ArrayList<Node>(1);
        this.build(this.xmid, this.ymid, 0, cells, new StringBuilder(), (Shape)this.ctx.makePoint(p.getX(), p.getY()), level);
        return (Node)cells.get(0);
    }

    @Override
    public Node getNode(String token) {
        return new QuadCell(token);
    }

    @Override
    public Node getNode(byte[] bytes, int offset, int len) {
        return new QuadCell(bytes, offset, len);
    }

    private void build(double x, double y, int level, List<Node> matches, StringBuilder str, Shape shape, int maxLevel) {
        assert (str.length() == level);
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        this.checkBattenberg('A', x - w, y + h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('B', x + w, y + h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('C', x - w, y - h, level, matches, str, shape, maxLevel);
        this.checkBattenberg('D', x + w, y - h, level, matches, str, shape, maxLevel);
    }

    private void checkBattenberg(char c, double cx, double cy, int level, List<Node> matches, StringBuilder str, Shape shape, int maxLevel) {
        assert (str.length() == level);
        double w = this.levelW[level] / 2.0;
        double h = this.levelH[level] / 2.0;
        int strlen = str.length();
        Rectangle rectangle = this.ctx.makeRectangle(cx - w, cx + w, cy - h, cy + h);
        SpatialRelation v = shape.relate((Shape)rectangle);
        if (SpatialRelation.CONTAINS == v) {
            str.append(c);
            matches.add(new QuadCell(str.toString(), v.transpose()));
        } else if (SpatialRelation.DISJOINT != v) {
            str.append(c);
            int nextLevel = level + 1;
            if (nextLevel >= maxLevel) {
                matches.add(new QuadCell(str.toString(), v.transpose()));
            } else {
                this.build(cx, cy, nextLevel, matches, str, shape, maxLevel);
            }
        }
        str.setLength(strlen);
    }

    class QuadCell
    extends Node {
        private Shape shape;

        public QuadCell(String token) {
            super(token);
        }

        public QuadCell(String token, SpatialRelation shapeRel) {
            super(token);
            this.shapeRel = shapeRel;
        }

        QuadCell(byte[] bytes, int off, int len) {
            super(bytes, off, len);
        }

        @Override
        public void reset(byte[] bytes, int off, int len) {
            super.reset(bytes, off, len);
            this.shape = null;
        }

        @Override
        public Collection<Node> getSubCells() {
            ArrayList<Node> cells = new ArrayList<Node>(4);
            cells.add(new QuadCell(this.getTokenString() + "A"));
            cells.add(new QuadCell(this.getTokenString() + "B"));
            cells.add(new QuadCell(this.getTokenString() + "C"));
            cells.add(new QuadCell(this.getTokenString() + "D"));
            return cells;
        }

        @Override
        public int getSubCellsSize() {
            return 4;
        }

        @Override
        public Node getSubCell(Point p) {
            return QuadPrefixTree.this.getNode(p, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = this.makeShape();
            }
            return this.shape;
        }

        private Rectangle makeShape() {
            double height;
            double width;
            String token = this.getTokenString();
            double xmin = QuadPrefixTree.this.xmin;
            double ymin = QuadPrefixTree.this.ymin;
            for (int i = 0; i < token.length(); ++i) {
                char c = token.charAt(i);
                if ('A' == c || 'a' == c) {
                    ymin += QuadPrefixTree.this.levelH[i];
                    continue;
                }
                if ('B' == c || 'b' == c) {
                    xmin += QuadPrefixTree.this.levelW[i];
                    ymin += QuadPrefixTree.this.levelH[i];
                    continue;
                }
                if ('C' == c || 'c' == c) continue;
                if ('D' == c || 'd' == c) {
                    xmin += QuadPrefixTree.this.levelW[i];
                    continue;
                }
                throw new RuntimeException("unexpected char: " + c);
            }
            int len = token.length();
            if (len > 0) {
                width = QuadPrefixTree.this.levelW[len - 1];
                height = QuadPrefixTree.this.levelH[len - 1];
            } else {
                width = QuadPrefixTree.this.gridW;
                height = QuadPrefixTree.this.gridH;
            }
            return QuadPrefixTree.this.ctx.makeRectangle(xmin, xmin + width, ymin, ymin + height);
        }
    }

    public static class Factory
    extends SpatialPrefixTreeFactory {
        @Override
        protected int getLevelForDistance(double degrees) {
            QuadPrefixTree grid = new QuadPrefixTree(this.ctx, 50);
            return grid.getLevelForDistance(degrees);
        }

        @Override
        protected SpatialPrefixTree newSPT() {
            return new QuadPrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : 50);
        }
    }
}

