/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.plugins.FactoryType;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.di.AmbiguousInjectConstructorException;
import org.apache.logging.log4j.plugins.di.DependencyChain;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.NotInjectableException;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.InternalApi;

@InternalApi
public final class BeanUtils {
    private BeanUtils() {
    }

    public static String decapitalize(String string) {
        if (string.isEmpty()) {
            return string;
        }
        char[] chars = string.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return string;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Executable getInjectableFactory(Class<?> clazz) {
        return Stream.of(clazz.getDeclaredMethods()).filter(method -> Modifier.isStatic(method.getModifiers()) && AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class)).min(Comparator.comparingInt(Method::getParameterCount).thenComparing(Method::getReturnType, (c1, c2) -> {
            if (c1.equals(c2)) {
                return 0;
            }
            if (Supplier.class.isAssignableFrom((Class<?>)c1)) {
                return -1;
            }
            if (Supplier.class.isAssignableFrom((Class<?>)c2)) {
                return 1;
            }
            return c1.getName().compareTo(c2.getName());
        })).map(Executable.class::cast).orElseGet(() -> BeanUtils.getInjectableConstructor(clazz));
    }

    public static <T> Constructor<T> getInjectableConstructor(Class<T> clazz) {
        Constructor<T> constructor = BeanUtils.findInjectableConstructor(clazz);
        if (constructor == null) {
            throw new NotInjectableException(clazz);
        }
        return constructor;
    }

    public static <T> Constructor<T> getInjectableConstructor(Key<T> key, DependencyChain chain) {
        Constructor<T> constructor = BeanUtils.findInjectableConstructor(key.getRawType());
        if (constructor == null) {
            throw new NotInjectableException(key, chain);
        }
        return constructor;
    }

    public static boolean isInjectable(Field field) {
        return field.isAnnotationPresent(Inject.class) || AnnotationUtil.isMetaAnnotationPresent(field, QualifierType.class);
    }

    public static boolean isInjectable(Method method) {
        if (method.isAnnotationPresent(Inject.class)) {
            return true;
        }
        if (!AnnotationUtil.isMetaAnnotationPresent(method, FactoryType.class)) {
            for (Parameter parameter : method.getParameters()) {
                if (!AnnotationUtil.isMetaAnnotationPresent(parameter, QualifierType.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static <T> Constructor<T> findInjectableConstructor(Class<T> clazz) {
        List constructors = Stream.of(clazz.getDeclaredConstructors()).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).collect(Collectors.toList());
        int size = constructors.size();
        if (size > 1) {
            throw new AmbiguousInjectConstructorException(clazz);
        }
        if (size == 1) {
            return (Constructor)Cast.cast(constructors.get(0));
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
    }
}

