/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Locale;
import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolvers;
import org.apache.logging.log4j.layout.template.json.util.JsonReader;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class CaseConverterResolver
implements EventResolver {
    private final TemplateResolver<LogEvent> inputResolver;
    private final Function<String, String> converter;
    private final ErrorHandlingStrategy errorHandlingStrategy;
    private final TemplateResolver<LogEvent> replacementResolver;

    CaseConverterResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.inputResolver = CaseConverterResolver.createDelegate(context, config);
        this.converter = CaseConverterResolver.createConverter(config);
        this.errorHandlingStrategy = CaseConverterResolver.readErrorHandlingStrategy(config);
        this.replacementResolver = CaseConverterResolver.createReplacement(context, config);
    }

    private static TemplateResolver<LogEvent> createDelegate(EventResolverContext context, TemplateResolverConfig config) {
        Object delegateObject = config.getObject("input");
        return TemplateResolvers.ofObject(context, delegateObject);
    }

    private static Function<String, String> createConverter(TemplateResolverConfig config) {
        Locale locale = config.getLocale("locale");
        String _case = config.getString("case");
        if ("upper".equals(_case)) {
            return input -> input.toUpperCase(locale);
        }
        if ("lower".equals(_case)) {
            return input -> input.toLowerCase(locale);
        }
        throw new IllegalArgumentException("invalid case: " + config);
    }

    private static ErrorHandlingStrategy readErrorHandlingStrategy(TemplateResolverConfig config) {
        String strategyName = config.getString("errorHandlingStrategy");
        if (strategyName == null) {
            return ErrorHandlingStrategy.REPLACE;
        }
        for (ErrorHandlingStrategy strategy : ErrorHandlingStrategy.values()) {
            if (!strategy.name.equals(strategyName)) continue;
            return strategy;
        }
        throw new IllegalArgumentException("illegal error handling strategy: " + config);
    }

    private static TemplateResolver<LogEvent> createReplacement(EventResolverContext context, TemplateResolverConfig config) {
        Object replacementObject = config.getObject("replacement");
        return TemplateResolvers.ofObject(context, replacementObject);
    }

    static String getName() {
        return "caseConverter";
    }

    @Override
    public boolean isFlattening() {
        return this.inputResolver.isFlattening();
    }

    @Override
    public boolean isResolvable() {
        return this.inputResolver.isResolvable();
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.inputResolver.isResolvable(logEvent);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        int startIndex = jsonWriter.getStringBuilder().length();
        this.inputResolver.resolve(logEvent, jsonWriter);
        this.convertCase(logEvent, jsonWriter, startIndex);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter, boolean succeedingEntry) {
        int startIndex = jsonWriter.getStringBuilder().length();
        this.inputResolver.resolve(logEvent, jsonWriter, succeedingEntry);
        this.convertCase(logEvent, jsonWriter, startIndex);
    }

    private void convertCase(LogEvent logEvent, JsonWriter jsonWriter, int startIndex) {
        boolean stringTyped;
        StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
        int endIndex = jsonWriterStringBuilder.length();
        boolean bl = stringTyped = startIndex + 1 < endIndex && jsonWriterStringBuilder.charAt(startIndex) == '\"' && jsonWriterStringBuilder.charAt(endIndex - 1) == '\"';
        if (stringTyped) {
            String json = jsonWriterStringBuilder.substring(startIndex, endIndex);
            this.convertCase(logEvent, jsonWriter, startIndex, json);
        } else {
            if (ErrorHandlingStrategy.FAIL.equals((Object)this.errorHandlingStrategy)) {
                String json = jsonWriterStringBuilder.substring(startIndex, endIndex);
                throw new RuntimeException("was expecting a string value, found: " + json);
            }
            if (!ErrorHandlingStrategy.PASS.equals((Object)this.errorHandlingStrategy)) {
                if (ErrorHandlingStrategy.REPLACE.equals((Object)this.errorHandlingStrategy)) {
                    jsonWriterStringBuilder.setLength(startIndex);
                    this.replacementResolver.resolve(logEvent, jsonWriter);
                } else {
                    throw new AssertionError((Object)"should not have reached here");
                }
            }
        }
    }

    private void convertCase(LogEvent logEvent, JsonWriter jsonWriter, int startIndex, String json) {
        String convertedString;
        StringBuilder jsonWriterStringBuilder = jsonWriter.getStringBuilder();
        String string = (String)JsonReader.read(json);
        try {
            convertedString = this.converter.apply(string);
        }
        catch (Exception error) {
            if (ErrorHandlingStrategy.FAIL.equals((Object)this.errorHandlingStrategy)) {
                throw new RuntimeException("case conversion failure for string: " + string, error);
            }
            if (ErrorHandlingStrategy.PASS.equals((Object)this.errorHandlingStrategy)) {
                return;
            }
            if (ErrorHandlingStrategy.REPLACE.equals((Object)this.errorHandlingStrategy)) {
                jsonWriterStringBuilder.setLength(startIndex);
                this.replacementResolver.resolve(logEvent, jsonWriter);
                return;
            }
            throw new AssertionError((Object)"should not have reached here");
        }
        jsonWriterStringBuilder.setLength(startIndex);
        jsonWriter.writeString(convertedString);
    }

    private static enum ErrorHandlingStrategy {
        FAIL("fail"),
        PASS("pass"),
        REPLACE("replace");

        private final String name;

        private ErrorHandlingStrategy(String name) {
            this.name = name;
        }
    }
}

