/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.couchdb;

import java.lang.reflect.Method;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.nosql.NoSqlProvider;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverters;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidPort;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.couchdb.CouchDbConnection;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;
import org.lightcouch.CouchDbClient;
import org.lightcouch.CouchDbProperties;

@Plugin(name="CouchDB", category="Core", printObject=true)
public final class CouchDbProvider
implements NoSqlProvider<CouchDbConnection> {
    private static final int HTTP = 80;
    private static final int HTTPS = 443;
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final CouchDbClient client;
    private final String description;

    private CouchDbProvider(CouchDbClient client, String description) {
        this.client = client;
        this.description = "couchDb{ " + description + " }";
    }

    public CouchDbConnection getConnection() {
        return new CouchDbConnection(this.client);
    }

    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static CouchDbProvider createNoSqlProvider(@PluginAttribute(value="databaseName") String databaseName, @PluginAttribute(value="protocol") String protocol, @PluginAttribute(value="server", defaultString="localhost") @ValidHost String server, @PluginAttribute(value="port", defaultString="0") @ValidPort String port, @PluginAttribute(value="username") String username, @PluginAttribute(value="password", sensitive=true) String password, @PluginAttribute(value="factoryClassName") String factoryClassName, @PluginAttribute(value="factoryMethodName") String factoryMethodName) {
        String description;
        CouchDbClient client;
        if (Strings.isNotEmpty((CharSequence)factoryClassName) && Strings.isNotEmpty((CharSequence)factoryMethodName)) {
            try {
                Class factoryClass = LoaderUtil.loadClass((String)factoryClassName);
                Method method = factoryClass.getMethod(factoryMethodName, new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (object instanceof CouchDbClient) {
                    client = (CouchDbClient)object;
                    description = "uri=" + client.getDBUri();
                }
                if (object instanceof CouchDbProperties) {
                    CouchDbProperties properties = (CouchDbProperties)object;
                    client = new CouchDbClient(properties);
                    description = "uri=" + client.getDBUri() + ", username=" + properties.getUsername() + ", passwordHash=" + NameUtil.md5((String)(password + CouchDbProvider.class.getName())) + ", maxConnections=" + properties.getMaxConnections() + ", connectionTimeout=" + properties.getConnectionTimeout() + ", socketTimeout=" + properties.getSocketTimeout();
                }
                if (object == null) {
                    LOGGER.error("The factory method [{}.{}()] returned null.", (Object)factoryClassName, (Object)factoryMethodName);
                    return null;
                }
                LOGGER.error("The factory method [{}.{}()] returned an unsupported type [{}].", (Object)factoryClassName, (Object)factoryMethodName, (Object)object.getClass().getName());
                return null;
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("The factory class [{}] could not be loaded.", (Object)factoryClassName, (Object)e);
                return null;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("The factory class [{}] does not have a no-arg method named [{}].", (Object)factoryClassName, (Object)factoryMethodName, (Object)e);
                return null;
            }
            catch (Exception e) {
                LOGGER.error("The factory method [{}.{}()] could not be invoked.", (Object)factoryClassName, (Object)factoryMethodName, (Object)e);
                return null;
            }
        } else if (Strings.isNotEmpty((CharSequence)databaseName)) {
            if (protocol != null && protocol.length() > 0) {
                if (!(protocol = protocol.toLowerCase()).equals("http") && !protocol.equals("https")) {
                    LOGGER.error("Only protocols [http] and [https] are supported, [{}] specified.", (Object)protocol);
                    return null;
                }
            } else {
                protocol = "http";
                LOGGER.warn("No protocol specified, using default port [http].");
            }
            int portInt = (Integer)TypeConverters.convert((String)port, Integer.TYPE, (Object)(protocol.equals("https") ? 443 : 80));
            if (Strings.isEmpty((CharSequence)username) || Strings.isEmpty((CharSequence)password)) {
                LOGGER.error("You must provide a username and password for the CouchDB provider.");
                return null;
            }
            client = new CouchDbClient(databaseName, false, protocol, server, portInt, username, password);
            description = "uri=" + client.getDBUri() + ", username=" + username + ", passwordHash=" + NameUtil.md5((String)(password + CouchDbProvider.class.getName()));
        } else {
            LOGGER.error("No factory method was provided so the database name is required.");
            return null;
        }
        return new CouchDbProvider(client, description);
    }
}

