/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public class ObjectMessage
implements Message,
StringBuilderFormattable {
    private static final long serialVersionUID = -5903272448334166185L;
    private transient Object obj;
    private transient String objectString;

    public ObjectMessage(Object obj) {
        this.obj = obj == null ? "null" : obj;
    }

    @Override
    public String getFormattedMessage() {
        if (this.objectString == null) {
            this.objectString = String.valueOf(this.obj);
        }
        return this.objectString;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        if (this.obj == null || this.obj instanceof String) {
            buffer.append((String)this.obj);
        } else if (this.obj instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)this.obj).formatTo(buffer);
        } else if (this.obj instanceof CharSequence) {
            buffer.append((CharSequence)this.obj);
        } else if (this.obj instanceof Integer) {
            buffer.append((Integer)this.obj);
        } else if (this.obj instanceof Long) {
            buffer.append((Long)this.obj);
        } else if (this.obj instanceof Double) {
            buffer.append((Double)this.obj);
        } else if (this.obj instanceof Boolean) {
            buffer.append((Boolean)this.obj);
        } else if (this.obj instanceof Character) {
            buffer.append(((Character)this.obj).charValue());
        } else if (this.obj instanceof Short) {
            buffer.append(((Short)this.obj).shortValue());
        } else if (this.obj instanceof Float) {
            buffer.append(((Float)this.obj).floatValue());
        } else {
            buffer.append(this.obj);
        }
    }

    @Override
    public String getFormat() {
        return this.getFormattedMessage();
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.obj};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMessage that = (ObjectMessage)o;
        return this.obj == null ? that.obj == null : this.equalObjectsOrStrings(this.obj, that.obj);
    }

    private boolean equalObjectsOrStrings(Object left, Object right) {
        return left.equals(right) || String.valueOf(left).equals(String.valueOf(right));
    }

    public int hashCode() {
        return this.obj != null ? this.obj.hashCode() : 0;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.obj instanceof Serializable) {
            out.writeObject(this.obj);
        } else {
            out.writeObject(String.valueOf(this.obj));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.obj = in.readObject();
    }

    @Override
    public Throwable getThrowable() {
        return this.obj instanceof Throwable ? (Throwable)this.obj : null;
    }
}

