/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ProviderUtil;

public final class PropertiesUtil {
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("log4j2.component.properties");
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Properties props;

    public PropertiesUtil(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Properties loadClose(InputStream in, Object source) {
        Properties props;
        block11: {
            props = new Properties();
            if (null != in) {
                props.load(in);
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close {}", source, e);
                }
                break block11;
                catch (IOException e) {
                    try {
                        LOGGER.error("Unable to read {}", source, e);
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            LOGGER.error("Unable to close {}", source, e2);
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        LOGGER.error("Unable to close {}", source, e3);
                    }
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertiesUtil(String propsLocn) {
        super();
        loader = ProviderUtil.findClassLoader();
        properties = new Properties();
        try {
            enumeration = loader.getResources(propsLocn);
            while (enumeration.hasMoreElements()) {
                url = enumeration.nextElement();
                in = url.openStream();
                try {
                    properties.load(in);
                    ** GOTO lbl23
                }
                catch (IOException ioe) {
                    try {
                        PropertiesUtil.LOGGER.error("Unable to read {}", new Object[]{url.toString()});
                    }
                    catch (Throwable var8_12) {
                        try {
                            in.close();
                            throw var8_12;
                        }
                        catch (IOException ioe) {
                            PropertiesUtil.LOGGER.error("Unable to close {}", new Object[]{url.toString(), ioe});
                        }
                        throw var8_12;
                    }
lbl23:
                    // 1 sources

                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        PropertiesUtil.LOGGER.error("Unable to close {}", new Object[]{url.toString(), ioe});
                    }
                    continue;
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {
                        PropertiesUtil.LOGGER.error("Unable to close {}", new Object[]{url.toString(), ioe});
                    }
                }
            }
        }
        catch (IOException ioe) {
            PropertiesUtil.LOGGER.error("Unable to access {}", new Object[]{propsLocn, ioe});
        }
        this.props = properties;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.props.getProperty(name) : prop;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Integer.parseInt(prop);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (prop == null) {
            prop = this.props.getProperty(name);
        }
        if (prop != null) {
            try {
                return Long.parseLong(prop);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException ex) {
            LOGGER.error("Unable to access system properties.", (Throwable)ex);
            return new Properties();
        }
    }
}

