/*
 * Decompiled with CFR 0.152.
 */
package jena;

import arq.cmdline.CmdARQ;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.spatial.SpatialIndex;
import org.apache.jena.query.spatial.SpatialIndexException;
import org.apache.jena.query.spatial.SpatialIndexLucene;
import org.apache.jena.query.spatial.assembler.SpatialVocab;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class spatialindexdump
extends CmdARQ {
    private static Logger log = LoggerFactory.getLogger(spatialindexdump.class);
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, new String[]{"desc", "dataset"});
    protected SpatialIndex spatialIndex = null;

    public static void main(String ... argv) {
        new spatialindexdump(argv).mainRun();
    }

    protected spatialindexdump(String[] argv) {
        super(argv);
        super.add(assemblerDescDecl, "--desc=", "Assembler description file");
    }

    protected void processModulesAndArgs() {
        String file;
        super.processModulesAndArgs();
        if (super.contains(assemblerDescDecl)) {
            if (this.getValues(assemblerDescDecl).size() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            if (this.getPositional().size() != 0) {
                throw new CmdException("Additional assembler descriptions given");
            }
            file = this.getValue(assemblerDescDecl);
        } else {
            if (this.getNumPositional() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            file = this.getPositionalArg(0);
        }
        this.spatialIndex = (SpatialIndex)AssemblerUtils.build((String)file, (Resource)SpatialVocab.spatialIndex);
    }

    protected String getSummary() {
        return this.getCommandName() + " assemblerFile";
    }

    protected void exec() {
        if (this.spatialIndex instanceof SpatialIndexLucene) {
            spatialindexdump.dump((SpatialIndexLucene)this.spatialIndex);
        } else {
            System.err.println("Unsupported index type : " + Lib.className((Object)this.spatialIndex));
        }
    }

    private static void dump(SpatialIndexLucene spatialIndex) {
        try {
            ScoreDoc[] sDocs;
            Directory directory = spatialIndex.getDirectory();
            Analyzer analyzer = spatialIndex.getAnalyzer();
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            QueryParser queryParser = new QueryParser(spatialIndex.getDocDef().getEntityField(), analyzer);
            Query query = queryParser.parse("*:*");
            for (ScoreDoc sd : sDocs = indexSearcher.search((Query)query, (int)1000).scoreDocs) {
                System.out.println("Doc: " + sd.doc);
                Document doc = indexSearcher.doc(sd.doc);
                for (IndexableField f : doc) {
                    System.out.println("  " + f.name() + " = " + f.stringValue());
                }
            }
        }
        catch (Exception ex) {
            throw new SpatialIndexException(ex);
        }
    }
}

