/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.spatial;

import com.spatial4j.core.distance.DistanceUtils;
import java.util.ArrayList;
import java.util.List;

public class DistanceUnitsUtils {
    public static final List<String> SUPPORTED_UNITS = new ArrayList<String>();

    public static double dist2Degrees(double dist, String units) {
        double degrees = dist;
        if (units.equals("kilometers") || units.equals("km")) {
            return DistanceUtils.dist2Degrees((double)dist, (double)6371.0087714);
        }
        if (units.equals("meters") || units.equals("m")) {
            return DistanceUtils.dist2Degrees((double)(dist / 1000.0), (double)6371.0087714);
        }
        if (units.equals("centimeters") || units.equals("cm")) {
            return DistanceUtils.dist2Degrees((double)(dist / 100000.0), (double)6371.0087714);
        }
        if (units.equals("milimeters") || units.equals("mm")) {
            return DistanceUtils.dist2Degrees((double)(dist / 1000000.0), (double)6371.0087714);
        }
        if (units.equals("miles") || units.equals("mi")) {
            return DistanceUtils.dist2Degrees((double)dist, (double)3958.7613145272735);
        }
        if (units.equals("degrees") || units.equals("de")) {
            return degrees;
        }
        throw new IllegalArgumentException("unknow distance units: " + units);
    }

    public static boolean isSupportedUnits(String units) {
        return SUPPORTED_UNITS.contains(units);
    }

    static {
        SUPPORTED_UNITS.add("kilometers");
        SUPPORTED_UNITS.add("km");
        SUPPORTED_UNITS.add("meters");
        SUPPORTED_UNITS.add("m");
        SUPPORTED_UNITS.add("centimeters");
        SUPPORTED_UNITS.add("cm");
        SUPPORTED_UNITS.add("milimeters");
        SUPPORTED_UNITS.add("mm");
        SUPPORTED_UNITS.add("miles");
        SUPPORTED_UNITS.add("mi");
        SUPPORTED_UNITS.add("degrees");
        SUPPORTED_UNITS.add("de");
    }
}

