/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntClassImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;

public class OntSimpleClassImpl
extends OntObjectImpl
implements OntClass {
    public OntSimpleClassImpl(Node n, EnhGraph eg) {
        super(n, eg);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntSimpleClassImpl.getOptionalRootStatement(this, OWL2.Class);
    }

    public Class<? extends OntClass> objectType() {
        return OntClass.class;
    }

    @Override
    public OntIndividual.Anonymous createIndividual() {
        return OntClassImpl.createAnonymousIndividual(this.getModel(), this);
    }

    @Override
    public OntIndividual.Named createIndividual(String uri) {
        return OntClassImpl.createNamedIndividual(this.getModel(), this, uri);
    }

    @Override
    public Stream<OntClass> superClasses(boolean direct) {
        return OntClassImpl.superClasses(this, direct);
    }

    @Override
    public Stream<OntClass> subClasses(boolean direct) {
        return OntClassImpl.subClasses(this, direct);
    }

    @Override
    public Stream<OntIndividual> individuals(boolean direct) {
        return OntClassImpl.individuals(this, direct);
    }

    @Override
    public boolean hasDeclaredProperty(OntProperty property, boolean direct) {
        return OntClassImpl.testDomain(this, property, direct);
    }

    @Override
    public Stream<OntProperty> declaredProperties(boolean direct) {
        return OntClassImpl.declaredProperties(this, direct);
    }

    @Override
    public boolean isHierarchyRoot() {
        return OntClassImpl.isHierarchyRoot(this);
    }

    @Override
    public OntList<OntRelationalProperty> createHasKey(Collection<OntObjectProperty> ope, Collection<OntDataProperty> dpe) {
        Stream<OntDataProperty> stream = Stream.concat(ope.stream(), dpe.stream());
        return OntClassImpl.createHasKey(this.getModel(), this, stream);
    }

    @Override
    public OntStatement addHasKeyStatement(OntRelationalProperty ... properties) {
        return OntClassImpl.createHasKey(this.getModel(), this, Arrays.stream(properties)).getMainStatement();
    }

    @Override
    public Stream<OntList<OntRelationalProperty>> hasKeys() {
        return OntClassImpl.listHasKeys(this.getModel(), this);
    }

    @Override
    public OntSimpleClassImpl removeHasKey(Resource list) throws OntJenaException.IllegalArgument {
        OntClassImpl.removeHasKey(this.getModel(), this, (RDFNode)list);
        return this;
    }

    @Override
    public boolean isDisjoint(Resource candidate) {
        return OntClassImpl.isDisjoint(this, candidate);
    }

    @Override
    public Stream<OntClass> disjointClasses() {
        return OntClassImpl.disjointClasses(this.getModel(), this);
    }

    @Override
    public Stream<OntClass> equivalentClasses() {
        return OntClassImpl.equivalentClasses(this.getModel(), this);
    }

    @Override
    public boolean hasSuperClass(OntClass clazz, boolean direct) {
        return OntClassImpl.hasSuperClass(this, clazz, direct);
    }

    @Override
    public OntClass addDisjointClass(OntClass other) {
        OntClassImpl.addDisjoint(this.getModel(), this, other);
        return this;
    }

    @Override
    public OntStatement addDisjointWithStatement(OntClass other) {
        return OntClassImpl.addDisjointWithStatement(this.getModel(), this, other);
    }

    @Override
    public OntClass removeDisjointClass(Resource other) {
        OntClassImpl.removeDisjoint(this.getModel(), this, other);
        return this;
    }

    @Override
    public OntStatement addEquivalentClassStatement(OntClass other) {
        return OntClassImpl.addEquivalentClass(this.getModel(), this, other);
    }

    @Override
    public OntClass removeEquivalentClass(Resource other) {
        OntClassImpl.removeEquivalentClass(this.getModel(), this, other);
        return this;
    }

    public static class NamedImpl
    extends OntSimpleClassImpl
    implements OntClass.Named {
        public NamedImpl(Node n, EnhGraph eg) {
            super(NamedImpl.checkNamed(n), eg);
        }

        @Override
        public OntClass.Named asNamed() {
            return this;
        }

        public Class<OntClass.Named> objectType() {
            return OntClass.Named.class;
        }

        @Override
        public boolean isBuiltIn() {
            return this.getModel().isBuiltIn(this);
        }

        @Override
        public Stream<OntList<OntClass>> disjointUnions() {
            if (!OntGraphModelImpl.configValue(this.getModel(), OntModelControls.USE_OWL2_NAMED_CLASS_DISJOINT_UNION_FEATURE)) {
                return Stream.empty();
            }
            return OntListImpl.stream(this.getModel(), this, OWL2.disjointUnionOf, OntClass.class);
        }

        @Override
        public OntList<OntClass> createDisjointUnion(Collection<OntClass> classes) {
            OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL2_NAMED_CLASS_DISJOINT_UNION_FEATURE, "owl:disjointUnionOf");
            return this.getModel().createOntList(this, OWL2.disjointUnionOf, OntClass.class, Objects.requireNonNull(classes).stream().distinct().iterator());
        }

        @Override
        public OntClass.Named removeDisjointUnion(Resource rdfList) throws OntJenaException.IllegalArgument {
            OntGraphModelImpl.checkFeature(this.getModel(), OntModelControls.USE_OWL2_NAMED_CLASS_DISJOINT_UNION_FEATURE, "owl:disjointUnionOf");
            this.getModel().deleteOntList(this, OWL2.disjointUnionOf, this.findDisjointUnion((RDFNode)rdfList).orElse(null));
            return this;
        }

        @Override
        public OntClass.Named removeDisjointClass(Resource other) {
            super.removeDisjointClass(other);
            return this;
        }

        @Override
        public OntClass.Named removeEquivalentClass(Resource other) {
            super.removeEquivalentClass(other);
            return this;
        }

        @Override
        public OntClass.Named addDisjointClass(OntClass other) {
            super.addDisjointClass(other);
            return this;
        }
    }

    public static class RLNamedImpl
    extends NamedImpl {
        public RLNamedImpl(Node n, EnhGraph eg) {
            super(n, eg);
        }

        @Override
        public OntClass asSubClass() {
            if (OWL2.Thing.equals((Object)this)) {
                throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
            }
            return this;
        }

        @Override
        public boolean canAsSubClass() {
            return !OWL2.Thing.equals((Object)this);
        }

        @Override
        public OntClass asSuperClass() {
            if (OWL2.Thing.equals((Object)this)) {
                throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
            }
            return this;
        }

        @Override
        public boolean canAsSuperClass() {
            return !OWL2.Thing.equals((Object)this);
        }

        @Override
        public OntClass asEquivalentClass() {
            if (OWL2.Thing.equals((Object)this)) {
                throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
            }
            return this;
        }

        @Override
        public boolean canAsEquivalentClass() {
            return !OWL2.Thing.equals((Object)this);
        }

        @Override
        public OntClass asDisjointClass() {
            if (OWL2.Thing.equals((Object)this)) {
                throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
            }
            return this;
        }

        @Override
        public boolean canAsDisjointClass() {
            return !OWL2.Thing.equals((Object)this);
        }
    }
}

