/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntAnnotationImpl;
import org.apache.jena.ontapi.impl.objects.OntStatementImpl;
import org.apache.jena.ontapi.model.OntAnnotationProperty;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Graphs;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.RDF;

public class OntObjectImpl
extends ResourceImpl
implements OntObject {
    public OntObjectImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    protected static Optional<OntStatement> getRequiredRootStatement(OntObjectImpl subject, Resource type) throws OntJenaException.IllegalState {
        Optional<OntStatement> res = OntObjectImpl.getOptionalRootStatement(subject, type);
        if (res.isEmpty()) {
            throw new OntJenaException.IllegalState("Can't find " + subject.getModel().shortForm(type.getURI()) + " declaration for " + subject);
        }
        return res;
    }

    protected static Optional<OntStatement> getOptionalRootStatement(OntObjectImpl subject, Resource type) {
        if (!subject.hasProperty(RDF.type, (RDFNode)OntObjectImpl.checkNamed(type))) {
            return Optional.empty();
        }
        return Optional.of(subject.getModel().createStatement(subject, RDF.type, (RDFNode)type).asRootStatement());
    }

    public static Node checkNamed(Node res) {
        if (OntJenaException.notNull(res, "Null node").isURI()) {
            return res;
        }
        throw new OntJenaException.IllegalArgument("Not uri node " + res);
    }

    public static Resource checkNamed(Resource res) {
        if (OntJenaException.notNull(res, "Null resource").isURIResource()) {
            return res;
        }
        throw new OntJenaException.IllegalArgument("Not uri resource " + res);
    }

    public static <X extends OntObject> Stream<X> subjects(Property predicate, OntObject object, Class<X> type) {
        return object.getModel().statements(null, predicate, (RDFNode)object).map(x -> (OntObject)x.getSubject().getAs(type)).filter(Objects::nonNull);
    }

    public static Class<? extends OntObject> findActualClass(OntObject o) {
        return OntObjectImpl.findActualClass(o.getClass());
    }

    public static Class<? extends OntObject> findActualClass(Class<? extends OntObject> type) {
        return Arrays.stream(type.getInterfaces()).filter(OntObject.class::isAssignableFrom).map(klass -> klass).findFirst().orElse(null);
    }

    public static <X extends RDFNode> X getNodeAs(RDFNode node, Class<X> view) {
        try {
            return (X)node.as(view);
        }
        catch (JenaException ignore) {
            return null;
        }
    }

    public static OntObject wrapAsOntObject(Node node, EnhGraph model) {
        return new OntObjectImpl(node, model);
    }

    public static boolean isReservedOrBuiltin(OntObject object) {
        if (!object.isURIResource()) {
            return false;
        }
        OntPersonality personality = OntEnhGraph.asPersonalityModel(object.getModel()).getOntPersonality();
        return personality.getBuiltins().get(object.objectType()).contains(object.asNode()) || personality.getReserved().getAllResources().contains(object.asNode());
    }

    static Property reasonerProperty(OntModel m, Property predicate) {
        if (m instanceof InfModel) {
            Reasoner reasoner = ((InfModel)m).getReasoner();
            if (reasoner == null) {
                return null;
            }
            Property candidate = m.getProperty(ReasonerRegistry.makeDirect((Node)predicate.asNode()).getURI());
            if (reasoner.supportsProperty(candidate)) {
                return candidate;
            }
        }
        return null;
    }

    protected int getCharacteristics() {
        return Graphs.getSpliteratorCharacteristics(this.getModel().getGraph());
    }

    @Override
    public boolean isLocal() {
        return this.findRootStatement().map(OntStatement::isLocal).orElse(false);
    }

    @Override
    public final OntStatement getMainStatement() {
        return this.findRootStatement().orElse(null);
    }

    @Override
    public Stream<OntStatement> spec() {
        return Iterators.asStream(this.listSpec(), this.getCharacteristics());
    }

    @Override
    public <X extends RDFNode> X getAs(Class<X> type) {
        return OntObjectImpl.getNodeAs((RDFNode)this, type);
    }

    public ExtendedIterator<OntStatement> listSpec() {
        return this.findRootStatement().map(Iterators::of).orElseGet(NullIterator::instance);
    }

    @Override
    public Stream<OntStatement> content() {
        return Iterators.fromSet(this::getContent);
    }

    protected Set<OntStatement> getContent() {
        Set res = this.listSpec().toSet();
        this.listStatements().filterDrop(OntStatement::isAnnotationAssertion).forEachRemaining(res::add);
        return res;
    }

    public Optional<OntStatement> findRootStatement() {
        return Iterators.findFirst(this.listObjects(RDF.type)).map(o -> this.getModel().createStatement(this, RDF.type, (RDFNode)o).asRootStatement());
    }

    protected OntObjectImpl changeRDFType(Resource type, boolean add) {
        if (add) {
            this.addStatement(RDF.type, (RDFNode)type);
        } else {
            this.remove(RDF.type, (RDFNode)type);
        }
        return this;
    }

    @Override
    public Optional<OntStatement> statement(Property property) {
        return Iterators.findFirst(this.listStatements(property));
    }

    @Override
    public Optional<OntStatement> statement(Property property, RDFNode value) {
        return Iterators.findFirst(this.getModel().listOntStatements(this, property, value));
    }

    @Override
    public OntStatement getRequiredProperty(Property property) throws PropertyNotFoundException {
        return this.statement(property).orElseThrow(() -> new PropertyNotFoundException(property));
    }

    protected ExtendedIterator<OntStatement> listRequired(Property ... properties) {
        return Iterators.of(properties).mapWith(this::getRequiredProperty);
    }

    @Override
    public OntStatement addStatement(Property property, RDFNode value) {
        OntStatementImpl res = this.getModel().createStatement(this, OntJenaException.notNull(property, "Null property."), OntJenaException.notNull(value, "Null value."));
        this.getModel().add(res);
        return res;
    }

    @Override
    public OntObjectImpl remove(Property property, RDFNode value) {
        OntGraphModelImpl m = this.getModel();
        m.listOntStatements(this, OntJenaException.notNull(property, "Null property."), value).toList().forEach(s -> m.remove(s.clearAnnotations()));
        return this;
    }

    @Override
    public Stream<OntStatement> statements(Property property) {
        return Iterators.asStream(this.listStatements(property), this.getCharacteristics());
    }

    @Override
    public Stream<OntStatement> statements() {
        return Iterators.asStream(this.listStatements(), this.getCharacteristics());
    }

    public StmtIterator listProperties() {
        return this.listProperties(null);
    }

    public ExtendedIterator<OntStatement> listStatements() {
        return this.listStatements(null);
    }

    public StmtIterator listProperties(Property p) {
        return StdModels.createStmtIterator((ExtendedIterator<Triple>)this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY), t -> this.createOntStatement(p, (Triple)t));
    }

    public ExtendedIterator<OntStatement> listStatements(Property p) {
        return Iterators.create(this.getModel().getGraph().find(this.asNode(), OntGraphModelImpl.asNode((RDFNode)p), Node.ANY).mapWith(t -> this.createOntStatement(p, (Triple)t)));
    }

    protected OntStatementImpl createOntStatement(Property p, Triple t) {
        OntGraphModelImpl m = this.getModel();
        Property property = p == null ? m.getNodeAs(t.getPredicate(), Property.class) : p;
        RDFNode object = m.getNodeAs(t.getObject(), RDFNode.class);
        return m.createStatement(this, property, object);
    }

    @Override
    public Stream<OntStatement> annotations() {
        return Iterators.asStream(this.listAnnotations(), this.getCharacteristics());
    }

    public ExtendedIterator<OntStatement> listAnnotations() {
        ExtendedIterator<OntStatement> res = this.listAssertions();
        Optional<OntStatement> main = this.findRootStatement();
        if (main.isEmpty()) {
            return res;
        }
        OntStatementImpl s = (OntStatementImpl)main.get();
        return res.andThen(Iterators.flatMap(s.listAnnotationResources(), a -> ((OntAnnotationImpl)a).listAssertions()));
    }

    public Stream<OntStatement> assertions() {
        return Iterators.asStream(this.listAssertions(), this.getCharacteristics());
    }

    public ExtendedIterator<OntStatement> listAssertions() {
        return this.listStatements().filterKeep(OntStatement::isAnnotationAssertion);
    }

    public ExtendedIterator<Literal> listAnnotationLiterals(OntAnnotationProperty predicate) {
        return this.listAnnotations().filterKeep(s -> Objects.equals(predicate, s.getPredicate())).mapWith(Statement::getObject).filterKeep(RDFNode::isLiteral).mapWith(RDFNode::asLiteral);
    }

    @Override
    public Stream<String> annotationValues(OntAnnotationProperty p, String lang) {
        if (lang == null) {
            return Iterators.asStream(this.listAnnotationLiterals(p).mapWith(Literal::getString));
        }
        return Iterators.asStream(this.listAnnotationLiterals(p)).sorted(Comparator.comparing(Literal::getLanguage)).filter(l -> {
            String target = l.getLanguage();
            if (lang.isEmpty()) {
                return target.isEmpty();
            }
            String x = target.length() > lang.length() ? target.substring(0, lang.length()) : target;
            return lang.equalsIgnoreCase(x);
        }).map(Literal::getString);
    }

    @Override
    public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
        return this.findRootStatement().map(r -> r.addAnnotation(property, value)).orElseGet(() -> this.getModel().createStatement(this.addProperty(property, value), property, value));
    }

    @Override
    public OntObjectImpl clearAnnotations() {
        Iterators.peek(this.listAssertions(), OntStatement::clearAnnotations).toSet().forEach(a -> this.getModel().remove((Statement)a));
        this.findRootStatement().ifPresent(OntStatement::clearAnnotations);
        return this;
    }

    public <T extends RDFNode> T getRequiredObject(Property predicate, Class<T> view) {
        return (T)((RDFNode)this.object(predicate, view).orElseThrow(() -> new OntJenaException(String.format("Can't find required object [%s @%s %s]", this, predicate, OntEnhNodeFactories.viewAsString(view)))));
    }

    public <T extends RDFNode> Optional<T> object(Property predicate, Class<T> type) {
        return Iterators.findFirst(this.listObjects(predicate, type));
    }

    @Override
    public <O extends RDFNode> Stream<O> objects(Property predicate, Class<O> type) {
        return Iterators.asStream(this.listObjects(predicate, type), predicate != null ? this.getCharacteristics() : 256);
    }

    public <O extends RDFNode> ExtendedIterator<O> listObjects(Property predicate, Class<O> type) {
        OntGraphModelImpl m = this.getModel();
        return this.listProperties(predicate).mapWith(s -> m.findNodeAs(s.getObject().asNode(), type)).filterDrop(Objects::isNull);
    }

    public <S extends RDFNode> ExtendedIterator<S> listSubjects(Property predicate, Class<S> type) {
        OntGraphModelImpl m = this.getModel();
        return m.listStatements(null, predicate, (RDFNode)this).mapWith(s -> m.findNodeAs(s.getSubject().asNode(), type)).filterDrop(Objects::isNull);
    }

    @Override
    public Stream<RDFNode> objects(Property predicate) {
        return Iterators.asStream(this.listObjects(predicate), predicate != null ? this.getCharacteristics() : 256);
    }

    public ExtendedIterator<RDFNode> listObjects(Property predicate) {
        return this.listProperties(predicate).mapWith(Statement::getObject);
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)this.enhGraph;
    }

    @Override
    public Class<? extends OntObject> objectType() {
        return OntObjectImpl.findActualClass(this);
    }

    public String toString() {
        Class<? extends OntObject> view = this.objectType();
        return view == null ? super.toString() : String.format("[%s]%s", OntEnhNodeFactories.viewAsString(view), this.asNode());
    }
}

