/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeManagerProvider;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeValidator;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.URLFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeValidatorFactory
implements ValidatorFactory {
    public static final String OPTION_CNDS = "cnds";
    public static final String OPTION_DEFAULT_NODE_TYPES = "defaultNodeType";
    public static final String OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES = "severityForUnknownNodetypes";
    public static final String OPTION_VALID_NAMESPACES = "validNameSpaces";
    @NotNull
    static final String DEFAULT_DEFAULT_NODE_TYPE = "nt:folder";
    @NotNull
    static final ValidationMessageSeverity DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE = ValidationMessageSeverity.WARN;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeTypeValidatorFactory.class);

    @Override
    @Nullable
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        ValidationMessageSeverity severityForUnknownNodetypes;
        String cndUrls = settings.getOptions().get(OPTION_CNDS);
        if (StringUtils.isBlank((CharSequence)cndUrls)) {
            cndUrls = this.getClass().getClassLoader().getResource("default-nodetypes.cnd").toString();
            LOGGER.warn("Using default nodetypes, consider specifying the nodetypes from the repository you use!");
        }
        String defaultNodeType = settings.getOptions().containsKey(OPTION_DEFAULT_NODE_TYPES) ? settings.getOptions().get(OPTION_DEFAULT_NODE_TYPES) : DEFAULT_DEFAULT_NODE_TYPE;
        if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES)) {
            String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES);
            severityForUnknownNodetypes = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
        } else {
            severityForUnknownNodetypes = DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE;
        }
        Map<Object, Object> validNameSpaces = settings.getOptions().containsKey(OPTION_VALID_NAMESPACES) ? NodeTypeValidatorFactory.parseNamespaces(settings.getOptions().get(OPTION_VALID_NAMESPACES)) : Collections.emptyMap();
        try {
            NodeTypeManagerProvider ntManagerProvider = null;
            ntManagerProvider = new NodeTypeManagerProvider();
            for (String string : NodeTypeValidatorFactory.resolveJarUrls(cndUrls.split("\\s*,\\s*"))) {
                try (InputStreamReader reader = new InputStreamReader(URLFactory.createURL(string).openStream(), StandardCharsets.US_ASCII);){
                    LOGGER.info("Register node types from {}", (Object)string);
                    ntManagerProvider.registerNodeTypes(reader);
                }
                catch (IOException | RepositoryException | ParseException e) {
                    throw new IllegalArgumentException("Error loading node types from CND at " + string, e);
                }
            }
            for (Map.Entry entry : validNameSpaces.entrySet()) {
                ntManagerProvider.registerNamespace((String)entry.getKey(), (String)entry.getValue());
            }
            return new NodeTypeValidator(context.getFilter(), ntManagerProvider, ntManagerProvider.getNameResolver().getQName(defaultNodeType), settings.getDefaultSeverity(), severityForUnknownNodetypes);
        }
        catch (IOException | RepositoryException | ParseException e) {
            throw new IllegalArgumentException("Error loading default node type " + defaultNodeType, e);
        }
    }

    static List<String> resolveJarUrls(String ... urls) {
        LinkedList<String> resolvedUrls = new LinkedList<String>();
        for (String url : urls) {
            if (url.endsWith(".jar")) {
                try {
                    URL jarUrl = URLFactory.createURL("jar:" + url + "!/");
                    JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
                    Manifest manifest = jarConnection.getManifest();
                    String slingNodetypes = manifest.getMainAttributes().getValue("Sling-Nodetypes");
                    if (slingNodetypes == null) {
                        LOGGER.warn("No 'Sling-Nodetypes' header found in manifest of '{}'", (Object)jarUrl);
                        continue;
                    }
                    for (String nodetype : slingNodetypes.split("\\s*,\\s*")) {
                        resolvedUrls.add(jarUrl.toString() + nodetype);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read from JAR " + url, e);
                }
            }
            resolvedUrls.add(url);
        }
        return resolvedUrls;
    }

    static Map<String, String> parseNamespaces(String optionValue) {
        String[] namespaces;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String namespace : namespaces = optionValue.split("\\s*,\\s*")) {
            String[] namespaceParts = namespace.split("\\s*=\\s*");
            if (namespaceParts.length != 2 || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{namespaceParts[0], namespaceParts[1]})) continue;
            result.put(namespaceParts[0], namespaceParts[1]);
        }
        return result;
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-nodetypes";
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

