/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.MetaInfPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.NodePathValidator;
import org.apache.jackrabbit.vault.validation.spi.PropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.impl.OakIndexDefinitionValidatorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageTypeValidator
implements NodePathValidator,
FilterValidator,
PropertiesValidator,
MetaInfPathValidator,
DocumentViewXmlValidator {
    protected static final String MESSAGE_FILTER_HAS_INCLUDE_EXCLUDES = "Package of type '%s' is not supposed to contain includes/excludes below any of its filters!";
    protected static final String MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE = "Package of type '%s' must only contain sub packages of type '%s' but found sub package of type '%s'!";
    protected static final String MESSAGE_UNSUPPORTED_SUB_PACKAGE = "Package of type '%s' is not supposed to contain any sub packages!";
    protected static final String MESSAGE_DEPENDENCY = "Package of type '%s' must not have package dependencies but found dependencies '%s'!";
    protected static final String MESSAGE_LEGACY_TYPE = "Package of type '%s' is legacy. Use one of the other types instead!";
    protected static final String MESSAGE_PACKAGE_HOOKS = "Package of type '%s' must not contain package hooks but has '%s'!";
    protected static final String MESSAGE_NO_PACKAGE_TYPE_SET = "No package type set, make sure that property 'packageType' is set in the properties.xml!";
    protected static final String MESSAGE_OSGI_BUNDLE_OR_CONFIG = "Package of type '%s' is not supposed to contain OSGi bundles or configurations!";
    protected static final String MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_OR_SUB_PACKAGE = "Package of type '%s' is not supposed to contain anything but OSGi bundles/configurations and sub packages!";
    protected static final String MESSAGE_APP_CONTENT = "Package of type '%s' is not supposed to contain content inside '/libs' and '/apps'!";
    protected static final String MESSAGE_NO_APP_CONTENT_FOUND = "Package of type '%s' is not supposed to contain content outside '/libs' and '/apps'!";
    protected static final String MESSAGE_INDEX_DEFINITIONS = "Package of type '%s' is not supposed to contain Oak index definitions but has 'allowIndexDefinitions' set to true.";
    protected static final String MESSAGE_PROHIBITED_MUTABLE_PACKAGE_TYPE = "All mutable package types are prohibited and this package is of mutable type '%s'";
    protected static final String MESSAGE_PROHIBITED_IMMUTABLE_PACKAGE_TYPE = "All mutable package types are prohibited and this package is of mutable type '%s'";
    protected static final String SLING_OSGI_CONFIG = "sling:OsgiConfig";
    protected static final Path PATH_HOOKS = Paths.get("vault", "hooks");
    @NotNull
    private final PackageType type;
    @NotNull
    private final ValidationMessageSeverity severity;
    @NotNull
    private final ValidationMessageSeverity severityForLegacyType;
    @NotNull
    private final Pattern jcrInstallerNodePathRegex;
    @NotNull
    private final Pattern additionalJcrInstallerFileNodePathRegex;
    @Nullable
    private final ValidationContext containerValidationContext;
    private final ValidationMessageSeverity severityForNoPackageType;
    private final boolean prohibitMutableContent;
    private final boolean prohibitImmutableContent;
    private final boolean allowComplexFilterRulesInApplicationPackages;
    @NotNull
    private final WorkspaceFilter filter;
    private List<String> validContainerNodePaths;
    private List<NodeContext> potentiallyDisallowedContainerNodes;

    public PackageTypeValidator(@NotNull WorkspaceFilter workspaceFilter, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForNoPackageType, @NotNull ValidationMessageSeverity severityForLegacyType, boolean prohibitMutableContent, boolean prohibitImmutableContent, boolean allowComplexFilterRulesInApplicationPackages, @NotNull PackageType type, @NotNull Pattern jcrInstallerNodePathRegex, @NotNull Pattern additionalJcrInstallerFileNodePathRegex, @Nullable ValidationContext containerValidationContext) {
        this.type = type;
        this.severity = severity;
        this.severityForNoPackageType = severityForNoPackageType;
        this.severityForLegacyType = severityForLegacyType;
        this.prohibitMutableContent = prohibitMutableContent;
        this.prohibitImmutableContent = prohibitImmutableContent;
        this.allowComplexFilterRulesInApplicationPackages = allowComplexFilterRulesInApplicationPackages;
        this.jcrInstallerNodePathRegex = jcrInstallerNodePathRegex;
        this.additionalJcrInstallerFileNodePathRegex = additionalJcrInstallerFileNodePathRegex;
        this.containerValidationContext = containerValidationContext;
        this.filter = workspaceFilter;
        this.validContainerNodePaths = new LinkedList<String>();
        this.potentiallyDisallowedContainerNodes = new LinkedList<NodeContext>();
    }

    boolean isOsgiBundleOrConfiguration(String nodePath, boolean onlyFile) {
        if (this.jcrInstallerNodePathRegex.matcher(nodePath).matches()) {
            if (onlyFile) {
                return this.additionalJcrInstallerFileNodePathRegex.matcher(nodePath).matches();
            }
            return true;
        }
        return false;
    }

    static boolean isSubPackage(String nodePath) {
        return nodePath.endsWith(".zip");
    }

    static boolean isAppContent(String nodePath) {
        return "/apps".equals(nodePath) || nodePath.startsWith("/apps/") || "/libs".equals(nodePath) || nodePath.startsWith("/libs/");
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        List invalidNodes = this.potentiallyDisallowedContainerNodes.stream().filter(s -> this.validContainerNodePaths.stream().noneMatch(p -> p.startsWith(s.getNodePath() + "/"))).collect(Collectors.toList());
        if (!invalidNodes.isEmpty()) {
            return invalidNodes.stream().map(e -> new ValidationMessage(this.severity, String.format(MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_OR_SUB_PACKAGE, this.type), e.getNodePath(), e.getFilePath(), e.getBasePath(), null)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull NodeContext nodeContext) {
        if (!this.filter.covers(nodeContext.getNodePath())) {
            return null;
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        switch (this.type) {
            case CONTENT: {
                if (PackageTypeValidator.isAppContent(nodeContext.getNodePath())) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_APP_CONTENT, this.type)));
                }
                if (!this.isOsgiBundleOrConfiguration(nodeContext.getNodePath(), true)) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_OSGI_BUNDLE_OR_CONFIG, this.type)));
                break;
            }
            case APPLICATION: {
                if (!PackageTypeValidator.isAppContent(nodeContext.getNodePath())) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_NO_APP_CONTENT_FOUND, this.type)));
                }
                if (!this.isOsgiBundleOrConfiguration(nodeContext.getNodePath(), true)) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_OSGI_BUNDLE_OR_CONFIG, this.type)));
                break;
            }
            case CONTAINER: {
                if (this.isOsgiBundleOrConfiguration(nodeContext.getNodePath(), false)) {
                    this.validContainerNodePaths.add(nodeContext.getNodePath());
                    break;
                }
                if (PackageTypeValidator.isSubPackage(nodeContext.getNodePath())) {
                    this.validContainerNodePaths.add(nodeContext.getNodePath());
                    break;
                }
                this.potentiallyDisallowedContainerNodes.add(nodeContext);
                break;
            }
        }
        return messages;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull WorkspaceFilter filter) {
        switch (this.type) {
            case APPLICATION: {
                if (this.allowComplexFilterRulesInApplicationPackages || !PackageTypeValidator.hasIncludesOrExcludes(filter)) break;
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_FILTER_HAS_INCLUDE_EXCLUDES, this.type)));
            }
        }
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull PackageProperties properties) {
        PackageType packageType = properties.getPackageType();
        if (packageType == null) {
            return Collections.singleton(new ValidationMessage(this.severityForNoPackageType, MESSAGE_NO_PACKAGE_TYPE_SET));
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        if (this.containerValidationContext != null) {
            messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Found sub package"));
            ValidationMessage message = this.validateSubPackageType(properties.getPackageType(), this.containerValidationContext.getProperties().getPackageType());
            if (message != null) {
                messages.add(message);
            }
        }
        switch (packageType) {
            case APPLICATION: {
                if (!properties.getExternalHooks().isEmpty()) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_PACKAGE_HOOKS, properties.getPackageType(), properties.getExternalHooks())));
                }
                if (OakIndexDefinitionValidatorFactory.areIndexDefinitionsAllowed(properties)) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_INDEX_DEFINITIONS, properties.getPackageType())));
                }
                if (!this.prohibitImmutableContent) break;
                messages.add(new ValidationMessage(this.severity, String.format("All mutable package types are prohibited and this package is of mutable type '%s'", properties.getPackageType())));
                break;
            }
            case CONTENT: {
                if (!this.prohibitMutableContent) break;
                messages.add(new ValidationMessage(this.severity, String.format("All mutable package types are prohibited and this package is of mutable type '%s'", properties.getPackageType())));
                break;
            }
            case CONTAINER: {
                if (properties.getDependencies() != null && properties.getDependencies().length > 0) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_DEPENDENCY, properties.getPackageType(), StringUtils.join((Object[])properties.getDependencies()))));
                }
                if (!this.prohibitImmutableContent) break;
                messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format("All mutable package types are prohibited and this package is of mutable type '%s'", properties.getPackageType())));
                break;
            }
            case MIXED: {
                messages.add(new ValidationMessage(this.severityForLegacyType, String.format(MESSAGE_LEGACY_TYPE, properties.getPackageType())));
                if (this.prohibitImmutableContent) {
                    messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format("All mutable package types are prohibited and this package is of mutable type '%s'", properties.getPackageType())));
                }
                if (!this.prohibitMutableContent) break;
                messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format("All mutable package types are prohibited and this package is of mutable type '%s'", properties.getPackageType())));
            }
        }
        return messages;
    }

    static boolean hasIncludesOrExcludes(WorkspaceFilter filter) {
        for (PathFilterSet set : filter.getFilterSets()) {
            if (set.getEntries().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private ValidationMessage validateSubPackageType(PackageType packageType, @Nullable PackageType containerPackageType) {
        ValidationMessage message = null;
        if (containerPackageType == null) {
            return null;
        }
        switch (containerPackageType) {
            case APPLICATION: {
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE, containerPackageType));
                break;
            }
            case CONTENT: {
                if (packageType == PackageType.CONTENT) break;
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE, containerPackageType, PackageType.CONTENT.toString(), packageType));
                break;
            }
            case CONTAINER: {
                if (packageType == PackageType.APPLICATION || packageType == PackageType.CONTAINER || packageType == PackageType.CONTENT) break;
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE, containerPackageType, StringUtils.join((Object[])new String[]{PackageType.APPLICATION.toString(), PackageType.CONTENT.toString(), PackageType.CONTAINER.toString()}, (String)", "), packageType));
                break;
            }
        }
        return message;
    }

    @Override
    public Collection<ValidationMessage> validateMetaInfPath(@NotNull Path filePath, @NotNull Path basePath, boolean isFolder) {
        switch (this.type) {
            case APPLICATION: {
                if (!filePath.startsWith(PATH_HOOKS)) break;
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_PACKAGE_HOOKS, this.type, filePath)));
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        switch (this.type) {
            case CONTENT: 
            case APPLICATION: {
                if (!this.jcrInstallerNodePathRegex.matcher(nodeContext.getNodePath()).matches() || !SLING_OSGI_CONFIG.equals(node.primary)) break;
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_OSGI_BUNDLE_OR_CONFIG, this.type)));
            }
        }
        return null;
    }
}

