/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.jackrabbit.vault.validation.ValidationViolation;
import org.apache.jackrabbit.vault.validation.impl.util.EnhancedBufferedInputStream;
import org.apache.jackrabbit.vault.validation.impl.util.ResettableInputStream;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorException;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericJcrDataValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericMetaInfDataValidator;
import org.apache.jackrabbit.vault.validation.spi.JcrPathValidator;
import org.apache.jackrabbit.vault.validation.spi.MetaInfPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodePathValidator;
import org.apache.jackrabbit.vault.validation.spi.PropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.impl.AdvancedFilterValidator;
import org.apache.jackrabbit.vault.validation.spi.impl.AdvancedPropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.impl.DocumentViewParserValidator;
import org.apache.jackrabbit.vault.validation.spi.util.NodeContextImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationExecutor {
    public static final String EXTENSION_BINARY = ".binary";
    private final Map<String, DocumentViewXmlValidator> documentViewXmlValidators;
    private final Map<String, NodePathValidator> nodePathValidators;
    private final Map<String, GenericJcrDataValidator> genericJcrDataValidators;
    private final Map<String, GenericMetaInfDataValidator> genericMetaInfDataValidators;
    private final Map<String, MetaInfPathValidator> metaInfPathValidators;
    private final Map<String, JcrPathValidator> jcrPathValidators;
    private final Map<String, FilterValidator> filterValidators;
    private final Map<String, PropertiesValidator> propertiesValidators;
    @NotNull
    private final Map<String, Validator> validatorsById;
    private static final Logger log = LoggerFactory.getLogger(ValidationExecutor.class);

    public ValidationExecutor(@NotNull Map<String, Validator> validatorsById) {
        this.validatorsById = validatorsById;
        this.documentViewXmlValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, DocumentViewXmlValidator.class);
        this.nodePathValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, NodePathValidator.class);
        this.genericJcrDataValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, GenericJcrDataValidator.class);
        this.genericMetaInfDataValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, GenericMetaInfDataValidator.class);
        this.metaInfPathValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, MetaInfPathValidator.class);
        this.jcrPathValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, JcrPathValidator.class);
        this.filterValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, FilterValidator.class);
        this.propertiesValidators = ValidationExecutor.filterValidatorsByClass(validatorsById, PropertiesValidator.class);
        for (Validator validator : validatorsById.values()) {
            if (validator instanceof AdvancedFilterValidator) {
                ((AdvancedFilterValidator)AdvancedFilterValidator.class.cast(validator)).setFilterValidators(this.filterValidators);
            }
            if (validator instanceof AdvancedPropertiesValidator) {
                ((AdvancedPropertiesValidator)AdvancedPropertiesValidator.class.cast(validator)).setPropertiesValidators(this.propertiesValidators);
            }
            if (!(validator instanceof DocumentViewParserValidator)) continue;
            ((DocumentViewParserValidator)DocumentViewParserValidator.class.cast(validator)).setDocumentViewXmlValidators(this.documentViewXmlValidators);
        }
    }

    @NotNull
    public Map<String, Validator> getAllValidatorsById() {
        return this.validatorsById;
    }

    @NotNull
    public Map<String, Validator> getUnusedValidatorsById() {
        HashMap<String, Validator> unusedValidators = new HashMap<String, Validator>(this.validatorsById);
        unusedValidators.keySet().removeAll(this.documentViewXmlValidators.keySet());
        unusedValidators.keySet().removeAll(this.nodePathValidators.keySet());
        unusedValidators.keySet().removeAll(this.metaInfPathValidators.keySet());
        unusedValidators.keySet().removeAll(this.jcrPathValidators.keySet());
        unusedValidators.keySet().removeAll(this.genericJcrDataValidators.keySet());
        unusedValidators.keySet().removeAll(this.genericMetaInfDataValidators.keySet());
        unusedValidators.keySet().removeAll(this.filterValidators.keySet());
        unusedValidators.keySet().removeAll(this.propertiesValidators.keySet());
        return unusedValidators;
    }

    @NotNull
    public Collection<ValidationViolation> validateMetaInf(@Nullable InputStream input, @NotNull Path filePath, @NotNull Path basePath) throws IOException {
        if (filePath.isAbsolute()) {
            throw new IllegalArgumentException("Given file path must not be absolute");
        }
        if (filePath.startsWith("META-INF")) {
            throw new IllegalArgumentException("Given file path must not start with META-INF but rather on the level below");
        }
        LinkedList<ValidationViolation> messages = new LinkedList<ValidationViolation>();
        messages.add(new ValidationViolation(ValidationMessageSeverity.DEBUG, "Validating meta inf file '" + filePath + "'..."));
        messages.addAll(this.validateGenericMetaInfData(input != null ? new EnhancedBufferedInputStream(input) : null, filePath, basePath));
        return messages;
    }

    @NotNull
    public Collection<ValidationViolation> validateJcrRoot(@Nullable InputStream input, @NotNull Path filePath, @NotNull Path basePath) throws IOException {
        if (filePath.isAbsolute()) {
            throw new IllegalArgumentException("Given path is not relative " + filePath);
        }
        if (filePath.startsWith("jcr_root")) {
            throw new IllegalArgumentException("Given file path must not start with jcr_root but rather on the level below");
        }
        LinkedList<ValidationViolation> messages = new LinkedList<ValidationViolation>();
        messages.add(new ValidationViolation(ValidationMessageSeverity.DEBUG, "Validating jcr file '" + filePath + "'..."));
        messages.addAll(this.validateGenericJcrData(input != null ? new EnhancedBufferedInputStream(input) : null, filePath, basePath));
        return messages;
    }

    @NotNull
    public Collection<ValidationViolation> done() {
        LinkedList<ValidationViolation> allViolations = new LinkedList<ValidationViolation>();
        for (Map.Entry<String, Validator> entry : this.validatorsById.entrySet()) {
            try {
                Collection<ValidationMessage> violations = entry.getValue().done();
                if (violations == null || violations.isEmpty()) continue;
                allViolations.addAll(ValidationViolation.wrapMessages(entry.getKey(), violations, null, null, null, 0, 0));
            }
            catch (RuntimeException e) {
                throw new ValidatorException(entry.getKey(), e);
            }
        }
        return allViolations;
    }

    private Collection<ValidationViolation> validateNodePaths(Path filePath, Path basePath, Map<String, Integer> nodePathsAndLineNumbers) {
        LinkedList<ValidationViolation> enrichedMessages = new LinkedList<ValidationViolation>();
        for (Map.Entry<String, Integer> nodePathAndLineNumber : nodePathsAndLineNumbers.entrySet()) {
            for (Map.Entry<String, NodePathValidator> entry : this.nodePathValidators.entrySet()) {
                enrichedMessages.add(new ValidationViolation(entry.getKey(), ValidationMessageSeverity.DEBUG, "Validate..."));
                try {
                    Collection<ValidationMessage> messages = entry.getValue().validate(new NodeContextImpl(nodePathAndLineNumber.getKey(), filePath, basePath));
                    if (messages == null || messages.isEmpty()) continue;
                    enrichedMessages.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, filePath, basePath, nodePathAndLineNumber.getKey(), nodePathAndLineNumber.getValue(), 0));
                }
                catch (RuntimeException e) {
                    throw new ValidatorException(entry.getKey(), nodePathAndLineNumber.getKey(), filePath, e);
                }
            }
        }
        return enrichedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<ValidationViolation> validateGenericMetaInfData(@Nullable InputStream input, @NotNull Path filePath, @NotNull Path basePath) throws IOException {
        LinkedList<ValidationViolation> enrichedMessages = new LinkedList<ValidationViolation>();
        for (Map.Entry<String, MetaInfPathValidator> entry : this.metaInfPathValidators.entrySet()) {
            Collection<ValidationMessage> messages = entry.getValue().validateMetaInfPath(filePath, basePath, input == null);
            if (messages == null || messages.isEmpty()) continue;
            enrichedMessages.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, filePath, basePath, null, 0, 0));
        }
        if (input == null) return enrichedMessages;
        InputStream currentInput = input;
        try (ResettableInputStream resettableInputStream = null;){
            for (Map.Entry<String, GenericMetaInfDataValidator> entry : this.genericMetaInfDataValidators.entrySet()) {
                try {
                    GenericMetaInfDataValidator validator = entry.getValue();
                    if (!validator.shouldValidateMetaInfData(filePath, basePath)) continue;
                    if (resettableInputStream == null) {
                        boolean isAnotherValidatorInterested = this.genericMetaInfDataValidators.values().stream().filter(t -> !t.equals(validator)).anyMatch(x -> x.shouldValidateMetaInfData(filePath, basePath));
                        if (isAnotherValidatorInterested) {
                            resettableInputStream = new ResettableInputStream(input);
                            currentInput = resettableInputStream;
                        }
                    } else {
                        resettableInputStream.reset();
                    }
                    enrichedMessages.add(new ValidationViolation(entry.getKey(), ValidationMessageSeverity.DEBUG, "Validate..."));
                    Collection<ValidationMessage> messages = validator.validateMetaInfData(currentInput, filePath, basePath);
                    if (messages == null || messages.isEmpty()) continue;
                    enrichedMessages.addAll(ValidationViolation.wrapMessages(entry.getKey(), messages, filePath, basePath, null, 0, 0));
                }
                catch (RuntimeException e) {
                    if (e instanceof ValidatorException) continue;
                    throw new ValidatorException(entry.getKey(), filePath, (Throwable)e);
                    return enrichedMessages;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Collection<ValidationViolation> validateGenericJcrData(@Nullable InputStream input, @NotNull Path filePath, @NotNull Path basePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    public static String filePathToNodePath(@NotNull Path filePath) {
        String repositoryPath;
        String platformPath = FilenameUtils.separatorsToUnix((String)filePath.toString());
        if (platformPath.endsWith(EXTENSION_BINARY)) {
            platformPath = Text.getRelativeParent((String)platformPath, (int)1);
        }
        repositoryPath = !(repositoryPath = PlatformNameFormat.getRepositoryPath((String)platformPath, (boolean)true)).isEmpty() ? "/" + repositoryPath : "/";
        return repositoryPath;
    }

    static <T> Map<String, T> filterValidatorsByClass(Map<String, Validator> allValidators, Class<T> type) {
        return allValidators.entrySet().stream().filter(x -> type.isInstance(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, x -> type.cast(x.getValue())));
    }

    private static /* synthetic */ boolean lambda$validateGenericJcrData$3(Path filePath, Path basePath, GenericJcrDataValidator x) {
        return x.shouldValidateJcrData(filePath, basePath);
    }

    private static /* synthetic */ boolean lambda$validateGenericJcrData$2(GenericJcrDataValidator validator, GenericJcrDataValidator t) {
        return !t.equals(validator);
    }
}

