/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMetadataPackageMojo
extends AbstractMojo {
    private static final String PROPERTIES_EMBEDDEDFILESMAP_KEY = "embeddedfiles.map";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="vault.metaInfVaultDirectory", required=true, defaultValue="${project.basedir}/META-INF/vault,${project.basedir}/src/main/META-INF/vault,${project.basedir}/src/main/content/META-INF/vault,${project.basedir}/src/content/META-INF/vault")
    File[] metaInfVaultDirectory;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    File workDirectory;
    @Parameter(property="vault.classifier")
    protected String classifier = "";
    @Parameter(property="vault.prefix", defaultValue="")
    String prefix = "";
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;

    protected String getProjectRelativeFilePath(File file) {
        return AbstractMetadataPackageMojo.getRelativePath(this.project.getBasedir().toPath(), file.toPath());
    }

    protected static String getRelativePath(Path base, Path file) {
        if (file.startsWith(base)) {
            return "'" + base.relativize(file).toString() + "'";
        }
        return "'" + file.toString() + "'";
    }

    protected static File getFirstExistingDirectory(File[] directories) {
        for (File dir : directories) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    public void setPrefix(String prefix) {
        if (prefix.startsWith("/")) {
            throw new IllegalArgumentException("Parameter 'prefix' must start with a slash!");
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.prefix = prefix;
    }

    void setEmbeddedFilesMap(Map<String, File> embeddedFiles) {
        this.getPluginContext().put(PROPERTIES_EMBEDDEDFILESMAP_KEY + this.classifier, embeddedFiles);
    }

    Map<String, File> getEmbeddedFilesMap() {
        Map<String, File> map = this.getEmbeddedFilesMap(PROPERTIES_EMBEDDEDFILESMAP_KEY + this.classifier);
        if (map == null) {
            this.getLog().debug((CharSequence)"Using regular embedded files map as classifier specific one does not exist!");
            map = this.getEmbeddedFilesMap(PROPERTIES_EMBEDDEDFILESMAP_KEY);
        }
        return map == null ? Collections.emptyMap() : map;
    }

    @Nullable
    private Map<String, File> getEmbeddedFilesMap(String key) {
        Object value = this.getPluginContext().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalStateException("The Maven property " + key + " is not containing a Map but rather " + value.getClass());
    }

    File getWorkDirectory(boolean isForWriting) {
        return AbstractMetadataPackageMojo.getWorkDirectory(this.getLog(), isForWriting, this.workDirectory, this.classifier);
    }

    static File getWorkDirectory(Log log, boolean isForWriting, File defaultWorkDirectory, String classifier) {
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            File classifierWorkDirectory = new File(defaultWorkDirectory.toString() + "-" + classifier);
            if (!isForWriting && !classifierWorkDirectory.exists()) {
                log.warn((CharSequence)("Using regular workDirectory " + defaultWorkDirectory + " as classifier specific workDirectory does not exist at " + classifierWorkDirectory));
                return defaultWorkDirectory;
            }
            return classifierWorkDirectory;
        }
        return defaultWorkDirectory;
    }

    File getGeneratedVaultDir(boolean isForWriting) {
        return new File(this.getWorkDirectory(isForWriting), "META-INF/vault");
    }

    File getGeneratedManifestFile(boolean isForWriting) {
        return new File(this.getWorkDirectory(isForWriting), "META-INF/MANIFEST.MF");
    }

    File getGeneratedFilterFile(boolean isForWriting) {
        return new File(this.getGeneratedVaultDir(isForWriting), "filter.xml");
    }

    protected File getMetaInfVaultSourceDirectory() {
        return AbstractMetadataPackageMojo.getMetaInfVaultSourceDirectory(this.metaInfVaultDirectory, this.getLog());
    }

    protected static File getMetaInfVaultSourceDirectory(File[] metaInfVaultDirectory, Log log) {
        File metaInfDirectory = AbstractMetadataPackageMojo.getFirstExistingDirectory(metaInfVaultDirectory);
        if (metaInfDirectory != null) {
            log.info((CharSequence)("Using META-INF/vault from " + metaInfDirectory.getPath()));
        }
        return metaInfDirectory;
    }

    protected static File resolveArtifact(Artifact artifact, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> repositories) throws MojoExecutionException {
        ArtifactRequest req = new ArtifactRequest(artifact, repositories, null);
        try {
            ArtifactResult resolutionResult = repoSystem.resolveArtifact(repoSession, req);
            return resolutionResult.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Artifact " + artifact + " could not be resolved.", (Exception)((Object)e));
        }
    }

    Filters loadGeneratedFilterFile() throws IOException, ConfigurationException {
        Filters filters = new Filters();
        filters.load(this.getGeneratedFilterFile(false));
        return filters;
    }
}

