/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.version.VersionRange;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportPackageBuilder {
    private File classFileDirectory;
    private List<File> classFiles;
    private List<Artifact> artifacts;
    private Analyzer analyzer;
    private ScanResult scanResult;
    private Map<String, BundleInfo> bundles = new HashMap<String, BundleInfo>();
    private Map<String, PackageInfo> exported = new HashMap<String, PackageInfo>();
    private Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
    private Map<String, Attrs> importParameters = Collections.emptyMap();
    private boolean includeUnused;
    private ArtifactFilter filter = new ArtifactFilter(){

        public boolean include(Artifact artifact) {
            return true;
        }
    };

    @NotNull
    public ImportPackageBuilder withClassFileDirectory(File classes) {
        this.classFileDirectory = classes;
        return this;
    }

    @NotNull
    public ImportPackageBuilder withDependenciesFromProject(@NotNull MavenProject project) {
        this.artifacts = new ArrayList<Artifact>();
        for (Artifact a : project.getDependencyArtifacts()) {
            if (!this.filter.include(a) || "test".equals(a.getScope()) || !"jar".equals(a.getType()) && !"bundle".equals(a.getType())) continue;
            this.artifacts.add(a);
        }
        return this;
    }

    @NotNull
    public ImportPackageBuilder withIncludeUnused(boolean includeUnused) {
        this.includeUnused = includeUnused;
        return this;
    }

    @NotNull
    public ImportPackageBuilder withFilter(@NotNull ArtifactFilter filter) {
        this.filter = filter;
        return this;
    }

    @NotNull
    public ImportPackageBuilder analyze() throws IOException {
        this.initClassFiles();
        this.initAnalyzer();
        this.scanClassPath();
        this.scanBundles();
        this.scanClasses();
        this.calculateImportParameters();
        return this;
    }

    @NotNull
    public Map<String, Attrs> getImportParameters() {
        return this.importParameters;
    }

    @NotNull
    public String createExportPackageReport() {
        TreeSet<String> unusedBundles = new TreeSet<String>(this.bundles.keySet());
        StringBuilder report = new StringBuilder("Export package report:\n\n");
        ArrayList<String> packages = new ArrayList<String>(this.exported.keySet());
        Collections.sort(packages);
        int pad = 18;
        for (String string : packages) {
            pad = Math.max(pad, string.length());
        }
        report.append(StringUtils.rightPad((String)"Exported packages", (int)(pad += 2))).append(StringUtils.rightPad((String)"Uses", (int)5)).append(StringUtils.rightPad((String)"Version", (int)10)).append("Dependency\n");
        report.append(StringUtils.repeat((String)"-", (int)(pad + 30))).append("\n");
        for (String string : packages) {
            PackageInfo info = this.exported.get(string);
            report.append(StringUtils.rightPad((String)string, (int)pad));
            report.append(StringUtils.rightPad((String)String.valueOf(info.usedBy.size()), (int)5));
            boolean first = true;
            for (BundleInfo bInfo : info.bundles.values()) {
                if (first) {
                    String version = (String)bInfo.packageVersions.get(string);
                    if (StringUtils.isEmpty((String)version)) {
                        version = "0.0.0";
                    }
                    report.append(StringUtils.rightPad((String)version, (int)10));
                    report.append(bInfo.getId());
                    first = false;
                }
                if (info.usedBy.isEmpty()) continue;
                unusedBundles.remove(bInfo.getId());
            }
            if (first) {
                report.append(StringUtils.rightPad((String)"n/a", (int)10));
            }
            report.append("\n");
        }
        report.append("\n").append(unusedBundles.size()).append(" unused bundles\n");
        report.append("------------------------------\n");
        for (String string : unusedBundles) {
            report.append(string).append("\n");
        }
        report.append("\nPackages used in the analyzed classes: \n");
        report.append("------------------------------\n");
        for (Map.Entry entry : this.importParameters.entrySet()) {
            report.append((String)entry.getKey());
            try {
                Processor.printClause((Map)((Map)entry.getValue()), (StringBuilder)report);
            }
            catch (IOException e1) {
                throw new IllegalStateException("Internal error while generating report", e1);
            }
            report.append("\n");
        }
        return report.toString();
    }

    private void initClassFiles() {
        if (!this.classFileDirectory.exists()) {
            this.classFiles = Collections.emptyList();
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.classFileDirectory);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        String[] paths = scanner.getIncludedFiles();
        this.classFiles = new ArrayList<File>(paths.length);
        for (String path : paths) {
            File file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(this.classFileDirectory, path);
            }
            this.classFiles.add(file);
        }
    }

    private ClassLoader getClassLoader() throws IOException, DependencyResolutionRequiredException {
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.add(this.classFileDirectory.toURI().toURL());
        for (Artifact a : this.artifacts) {
            classPath.add(a.getFile().toURI().toURL());
        }
        return new URLClassLoader(classPath.toArray(new URL[classPath.size()]), this.getClass().getClassLoader().getParent());
    }

    private void scanClassPath() throws IOException {
        try {
            this.scanResult = new ClassGraph().enableAllInfo().overrideClassLoaders(new ClassLoader[]{this.getClassLoader()}).scan();
        }
        catch (Exception e) {
            throw new IOException("Failed to scan the classpath", e);
        }
    }

    private void initAnalyzer() {
        this.analyzer = new Analyzer();
    }

    private void scanBundles() throws IOException {
        for (Artifact a : this.artifacts) {
            BundleInfo info = new BundleInfo(a);
            this.bundles.put(info.getId(), info);
            for (String pkgName : info.packageVersions.keySet()) {
                PackageInfo pkg = this.exported.get(pkgName);
                if (pkg == null) {
                    pkg = new PackageInfo(pkgName);
                    this.exported.put(pkgName, pkg);
                }
                pkg.bundles.put(info.getId(), info);
            }
        }
    }

    private void registerPackageReference(ClassInfo info, String pkgName) {
        PackageInfo pkgInfo = this.exported.get(pkgName);
        if (pkgInfo == null) {
            pkgInfo = new PackageInfo(pkgName);
            this.exported.put(pkgName, pkgInfo);
        }
        info.resolved.put(pkgName, pkgInfo);
        pkgInfo.usedBy.add(info.getName());
    }

    private void scanClasses() throws IOException {
        for (File file : this.classFiles) {
            try {
                Clazz clazz = new Clazz(this.analyzer, file.getPath(), (Resource)new FileResource(file));
                clazz.parseClassFile();
                ClassInfo info = new ClassInfo(clazz);
                this.classes.put(info.getName(), info);
                String myPackage = ImportPackageBuilder.getPackageName(info.getName());
                for (Descriptors.PackageRef ref : clazz.getReferred()) {
                    String importPkgName = ref.getFQN();
                    if (importPkgName.equals(myPackage)) continue;
                    this.registerPackageReference(info, importPkgName);
                }
                io.github.classgraph.ClassInfo clzInfo = this.scanResult.getClassInfo(clazz.getFQN());
                if (clzInfo == null) continue;
                for (String name : clzInfo.getInterfaces().getNames()) {
                    this.registerPackageReference(info, ImportPackageBuilder.getPackageName(name));
                }
                for (String name : clzInfo.getSuperclasses().getNames()) {
                    this.registerPackageReference(info, ImportPackageBuilder.getPackageName(name));
                }
            }
            catch (Exception e) {
                throw new IOException("Error while parsing class: " + file.getPath(), e);
            }
        }
    }

    private static String getPackageName(String className) {
        return StringUtils.chomp((String)className, (String)".");
    }

    private void calculateImportParameters() {
        this.importParameters = new TreeMap<String, Attrs>();
        for (PackageInfo info : this.exported.values()) {
            if (!this.classFiles.isEmpty() && info.usedBy.isEmpty() || this.classFiles.isEmpty() && !this.includeUnused || info.bundles.isEmpty()) continue;
            BundleInfo bInfo = (BundleInfo)info.bundles.values().iterator().next();
            String version = (String)bInfo.packageVersions.get(info.getName());
            Attrs options = new Attrs();
            if (!StringUtils.isEmpty((String)version)) {
                options.put("version", new VersionRange("@" + version).toString());
            }
            this.importParameters.put(info.getName(), options);
        }
    }

    private static class ClassInfo {
        private final Clazz clazz;
        private final Map<String, PackageInfo> resolved = new HashMap<String, PackageInfo>();

        private ClassInfo(Clazz clazz) {
            this.clazz = clazz;
        }

        public String getName() {
            return this.clazz.getFQN();
        }
    }

    private static class DirectoryDependency
    implements Dependency {
        private final File directory;

        private DirectoryDependency(File directory) {
            this.directory = directory;
        }

        @Override
        @Nullable
        public Manifest getManifest() throws IOException {
            File manifest = new File(this.directory, "META-INF/MANIFEST.MF");
            if (!manifest.exists()) {
                return null;
            }
            try (FileInputStream in = new FileInputStream(manifest);){
                Manifest manifest2 = new Manifest(in);
                return manifest2;
            }
        }

        @Override
        @NotNull
        public Collection<String> getClassFiles() throws IOException {
            Collection files = FileUtils.listFiles((File)this.directory, (String[])new String[]{"class"}, (boolean)true);
            String basePath = this.directory.getCanonicalPath();
            ArrayList<String> fileNames = new ArrayList<String>(files.size());
            for (File file : files) {
                String relativePath = file.getCanonicalPath().substring(basePath.length());
                fileNames.add(FilenameUtils.normalize((String)relativePath, (boolean)true));
            }
            return fileNames;
        }
    }

    private static class JarBasedDependency
    implements Dependency {
        private final File file;

        private JarBasedDependency(File file) {
            this.file = file;
        }

        @Override
        @Nullable
        public Manifest getManifest() throws IOException {
            try (JarFile jarFile = new JarFile(this.file);){
                Manifest manifest = jarFile.getManifest();
                return manifest;
            }
        }

        @Override
        @NotNull
        public Collection<String> getClassFiles() throws IOException {
            LinkedList<String> fileNames = new LinkedList<String>();
            try (JarFile jar = new JarFile(this.file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String path;
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory() || !(path = e.getName()).endsWith(".class")) continue;
                    fileNames.add(path);
                }
            }
            return fileNames;
        }
    }

    private static interface Dependency {
        @Nullable
        public Manifest getManifest() throws IOException;

        @NotNull
        public Collection<String> getClassFiles() throws IOException;
    }

    private static class BundleInfo {
        private final String id;
        private final Map<String, String> packageVersions = new HashMap<String, String>();

        private BundleInfo(Artifact artifact) throws IOException {
            String exportPackages;
            this.id = artifact.getId();
            File file = artifact.getFile();
            Dependency dependency = file.isDirectory() ? new DirectoryDependency(file) : new JarBasedDependency(file);
            Manifest manifest = dependency.getManifest();
            String string = exportPackages = manifest == null ? null : manifest.getMainAttributes().getValue("Export-Package");
            if (exportPackages != null) {
                for (Map.Entry entry : new Parameters(exportPackages).entrySet()) {
                    Attrs options = (Attrs)entry.getValue();
                    String version = options.getVersion();
                    this.packageVersions.put((String)entry.getKey(), version == null ? "" : version);
                }
            } else {
                for (String path : dependency.getClassFiles()) {
                    if (path.contains("/impl/") || path.contains("/internal/")) continue;
                    if ((path = StringUtils.chomp((String)path, (String)"/")).charAt(0) == '/') {
                        path = path.substring(1);
                    }
                    String packageName = path.replaceAll("/", ".");
                    this.packageVersions.put(packageName, "");
                }
            }
        }

        public String getId() {
            return this.id;
        }
    }

    private static class PackageInfo {
        private final String name;
        private final Map<String, BundleInfo> bundles = new HashMap<String, BundleInfo>();
        private final Set<String> usedBy = new HashSet<String>();

        private PackageInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

