/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;

public class ValidatorSettings
implements org.apache.jackrabbit.vault.validation.spi.ValidatorSettings {
    private final boolean isDisabled;
    private ValidationMessageSeverity defaultSeverity;
    private final Map<String, String> options = new HashMap<String, String>();

    public ValidatorSettings() {
        this.isDisabled = false;
    }

    public ValidatorSettings(ValidationMessageSeverity defaultSeverity) {
        this();
        this.defaultSeverity = defaultSeverity;
    }

    public ValidatorSettings setDefaultSeverity(String defaultSeverity) {
        if (defaultSeverity != null) {
            this.defaultSeverity = ValidationMessageSeverity.valueOf((String)defaultSeverity.toUpperCase());
        }
        return this;
    }

    protected ValidatorSettings addOption(String key, String value) {
        this.options.put(key, value);
        return this;
    }

    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverity != null ? this.defaultSeverity : ValidationMessageSeverity.ERROR;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public String toString() {
        return "ValidatorSettings [isDisabled=" + this.isDisabled + ", " + (this.defaultSeverity != null ? "defaultSeverity=" + this.defaultSeverity + ", " : "") + (this.options != null ? "options=" + this.options : "") + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultSeverity == null ? 0 : this.defaultSeverity.hashCode());
        result = 31 * result + (this.isDisabled ? 1231 : 1237);
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorSettings other = (ValidatorSettings)obj;
        if (this.defaultSeverity != other.defaultSeverity) {
            return false;
        }
        if (this.isDisabled != other.isDisabled) {
            return false;
        }
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }
}

