/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.filevault.maven.packaging.impl.ImportPackageBuilder;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;

@Mojo(name="analyze-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class AnalyzeClassesMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="vault.classesDirectory", defaultValue="${project.build.outputDirectory}")
    private File sourceDirectory;
    @Parameter(property="vault.showPackageReport", defaultValue="true")
    private boolean showImportPackageReport;
    @Parameter(property="vault.generatedImportPackage", defaultValue="${project.build.directory}/vault-generated-import.txt")
    private File generatedImportPackage;
    @Parameter(property="vault.importUnusedPackages")
    private boolean importUnusedPackages;
    @Parameter(property="vault.excludedLibraries")
    private String[] excludedLibraries;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"Analyzing java package dependencies.");
            ArrayList<String> excluded = new ArrayList<String>(this.excludedLibraries.length);
            for (String lib : this.excludedLibraries) {
                excluded.add(lib.trim());
            }
            ImportPackageBuilder builder = new ImportPackageBuilder().withFilter((ArtifactFilter)new PatternExcludesArtifactFilter(excluded)).withDependenciesFromProject(this.project).withClassFileDirectory(this.sourceDirectory).withIncludeUnused(this.importUnusedPackages).analyze();
            String report = builder.createExportPackageReport();
            if (this.showImportPackageReport) {
                this.getLog().info((CharSequence)report);
            }
            String importParams = Processor.printClauses(builder.getImportParameters());
            FileUtils.write((File)this.generatedImportPackage, (CharSequence)importParams, (String)"utf-8");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while analysing imports", (Exception)e);
        }
    }
}

