/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import javax.cache.CacheException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.h2.command.dml.SelectUnion;
import org.h2.util.StatementBuilder;

public class GridSqlUnion
extends GridSqlQuery {
    public static final int LEFT_CHILD = 2;
    public static final int RIGHT_CHILD = 3;
    private SelectUnion.UnionType unionType;
    private GridSqlQuery right;
    private GridSqlQuery left;

    @Override
    public <E extends GridSqlAst> E child(int childIdx) {
        if (childIdx < 2) {
            return super.child(childIdx);
        }
        switch (childIdx) {
            case 2: {
                assert (this.left != null);
                return (E)this.left;
            }
            case 3: {
                assert (this.right != null);
                return (E)this.right;
            }
        }
        throw new IllegalStateException("Child index: " + childIdx);
    }

    @Override
    public <E extends GridSqlAst> void child(int childIdx, E child) {
        if (childIdx < 2) {
            super.child(childIdx, child);
            return;
        }
        switch (childIdx) {
            case 2: {
                this.left = (GridSqlQuery)child;
                break;
            }
            case 3: {
                this.right = (GridSqlQuery)child;
                break;
            }
            default: {
                throw new IllegalStateException("Child index: " + childIdx);
            }
        }
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    protected int visibleColumns() {
        return this.left.visibleColumns();
    }

    @Override
    protected GridSqlElement column(int col) {
        throw new IllegalStateException();
    }

    @Override
    public String getSQL() {
        char delim = QueryUtils.delimeter();
        StatementBuilder buff = new StatementBuilder((String)(this.explain() ? "EXPLAIN " + delim : ""));
        buff.append('(').append(this.left.getSQL()).append(')');
        switch (this.unionType()) {
            case UNION_ALL: {
                buff.append(delim).append("UNION ALL").append(delim);
                break;
            }
            case UNION: {
                buff.append(delim).append("UNION").append(delim);
                break;
            }
            case INTERSECT: {
                buff.append(delim).append("INTERSECT").append(delim);
                break;
            }
            case EXCEPT: {
                buff.append(delim).append("EXCEPT").append(delim);
                break;
            }
            default: {
                throw new CacheException("type=" + this.unionType);
            }
        }
        buff.append('(').append(this.right.getSQL()).append(')');
        this.getSortLimitSQL(buff);
        return buff.toString();
    }

    @Override
    public boolean skipMergeTable() {
        return this.unionType() == SelectUnion.UnionType.UNION_ALL && this.sort().isEmpty() && this.offset() == null && this.limit() == null && this.left().skipMergeTable() && this.right().skipMergeTable();
    }

    public SelectUnion.UnionType unionType() {
        return this.unionType;
    }

    public void unionType(SelectUnion.UnionType unionType) {
        this.unionType = unionType;
    }

    public GridSqlQuery right() {
        return this.right;
    }

    public void right(GridSqlQuery right) {
        this.right = right;
    }

    public GridSqlQuery left() {
        return this.left;
    }

    public void left(GridSqlQuery left) {
        this.left = left;
    }
}

