/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2PkHashIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneIndex;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.index.Index;
import org.h2.table.IndexColumn;

public class H2TableDescriptor {
    public static final String PK_IDX_NAME = "_key_PK";
    public static final String PK_HASH_IDX_NAME = "_key_PK_hash";
    public static final String AFFINITY_KEY_IDX_NAME = "AFFINITY_KEY";
    private final IgniteH2Indexing idx;
    private final String fullTblName;
    private final GridQueryTypeDescriptor type;
    private final String schemaName;
    private final GridCacheContextInfo<?, ?> cacheInfo;
    private GridH2Table tbl;
    private GridLuceneIndex luceneIdx;
    private H2PkHashIndex pkHashIdx;

    public H2TableDescriptor(IgniteH2Indexing idx, String schemaName, GridQueryTypeDescriptor type, GridCacheContextInfo<?, ?> cacheInfo) {
        this.idx = idx;
        this.type = type;
        this.schemaName = schemaName;
        this.cacheInfo = cacheInfo;
        this.fullTblName = H2Utils.withQuotes(schemaName) + "." + H2Utils.withQuotes(type.tableName());
    }

    public IgniteH2Indexing indexing() {
        return this.idx;
    }

    public GridH2Table table() {
        return this.tbl;
    }

    public void table(GridH2Table tbl) {
        this.tbl = tbl;
    }

    public String schemaName() {
        return this.schemaName;
    }

    String tableName() {
        return this.type.tableName();
    }

    String fullTableName() {
        return this.fullTblName;
    }

    String typeName() {
        return this.type.name();
    }

    public String cacheName() {
        return this.cacheInfo.name();
    }

    public GridCacheContextInfo<?, ?> cacheInfo() {
        return this.cacheInfo;
    }

    GridQueryTypeDescriptor type() {
        return this.type;
    }

    GridLuceneIndex luceneIndex() {
        return this.luceneIdx;
    }

    public Index hashIndex() {
        return this.pkHashIdx;
    }

    public String toString() {
        return S.toString(H2TableDescriptor.class, (Object)this);
    }

    public void createHashIndex(GridH2Table tbl) {
        if (this.cacheInfo.affinityNode()) {
            List cols;
            IndexColumn keyCol = tbl.indexColumn(0, 0);
            IndexColumn affCol = tbl.getAffinityKeyColumn();
            if (affCol != null && H2Utils.equals(affCol, keyCol)) {
                affCol = null;
            }
            List list = cols = affCol == null ? Collections.singletonList(keyCol) : F.asList((Object[])new IndexColumn[]{keyCol, affCol});
            assert (this.pkHashIdx == null) : this.pkHashIdx;
            this.pkHashIdx = new H2PkHashIndex(this.cacheInfo.cacheContext(), tbl, PK_HASH_IDX_NAME, cols, tbl.rowDescriptor().context().config().getQueryParallelism());
        }
    }

    public void createTextIndex(GridH2Table tbl) {
        GridQueryIndexDescriptor textIdx;
        if (this.type().valueClass() == String.class && !this.idx.distributedConfiguration().isDisableCreateLuceneIndexForStringValueType()) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
        if ((textIdx = this.type.textIndex()) != null) {
            try {
                this.luceneIdx = new GridLuceneIndex(this.idx.kernalContext(), tbl.cacheName(), this.type);
            }
            catch (IgniteCheckedException e1) {
                throw new IgniteException((Throwable)e1);
            }
        }
    }

    void onDrop() {
        this.tbl.destroy();
        U.closeQuiet((AutoCloseable)this.luceneIdx);
    }
}

