/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Iterator;
import java.util.Objects;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.UnsortedBaseReducer;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;

public class UnsortedOneWayReducer
extends UnsortedBaseReducer {
    public UnsortedOneWayReducer(GridKernalContext ctx) {
        super(ctx);
    }

    public static UnsortedOneWayReducer createDummy(GridKernalContext ctx) {
        return new UnsortedOneWayReducer(ctx);
    }

    @Override
    protected Cursor findInStream(SearchRow first, SearchRow last) {
        assert (first == null && last == null) : "Invalid usage dummy reducer: [first=" + first + ", last=" + last + ']';
        return new OneWayFetchingCursor(new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                UnsortedOneWayReducer.this.iter = UnsortedOneWayReducer.this.pollNextIterator(UnsortedOneWayReducer.this.queue, UnsortedOneWayReducer.this.iter);
                return UnsortedOneWayReducer.this.iter.hasNext();
            }

            @Override
            public Row next() {
                return H2PlainRowFactory.create((Value[])UnsortedOneWayReducer.this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    private class OneWayFetchingCursor
    implements Cursor {
        private Iterator<Row> stream;
        private Row cur;

        OneWayFetchingCursor(Iterator<Row> stream) {
            assert (stream != null);
            this.stream = stream;
        }

        public boolean next() {
            if (!this.stream.hasNext()) {
                return false;
            }
            this.cur = Objects.requireNonNull(this.stream.next());
            return true;
        }

        public Row get() {
            return this.cur;
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

