/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.functions;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.hive.hplsql.Console;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.HplsqlParser;
import org.apache.hive.hplsql.Utils;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.functions.FuncCommand;
import org.apache.hive.hplsql.functions.FuncSpecCommand;

public class BuiltinFunctions {
    protected final Exec exec;
    protected final Console console;
    protected boolean trace;
    protected final QueryExecutor queryExecutor;
    protected HashMap<String, FuncCommand> map = new HashMap();
    protected HashMap<String, FuncSpecCommand> specMap = new HashMap();
    protected HashMap<String, FuncSpecCommand> specSqlMap = new HashMap();

    public BuiltinFunctions(Exec exec, QueryExecutor queryExecutor) {
        this.exec = exec;
        this.trace = exec.getTrace();
        this.console = exec.getConsole();
        this.queryExecutor = queryExecutor;
    }

    public void register(BuiltinFunctions f) {
    }

    public boolean exec(String name, HplsqlParser.Expr_func_paramsContext ctx) {
        FuncCommand func;
        if (name.contains(".")) {
            String[] parts = name.split("\\.");
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                if (i > 0) {
                    str.append(".");
                }
                str.append(parts[i].trim());
            }
            name = str.toString();
        }
        if (this.trace && ctx != null && ctx.parent != null && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.map.get(name.toUpperCase())) != null) {
            func.run(ctx);
            return true;
        }
        return false;
    }

    public boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return this.map.containsKey(name = name.toUpperCase()) || this.specMap.containsKey(name) || this.specSqlMap.containsKey(name);
    }

    public void specExec(HplsqlParser.Expr_spec_funcContext ctx) {
        FuncSpecCommand func;
        String name = ctx.start.getText().toUpperCase();
        if (this.trace && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.specMap.get(name)) != null) {
            func.run(ctx);
        } else if (ctx.T_MAX_PART_STRING() != null) {
            this.execMaxPartString(ctx);
        } else if (ctx.T_MIN_PART_STRING() != null) {
            this.execMinPartString(ctx);
        } else if (ctx.T_MAX_PART_INT() != null) {
            this.execMaxPartInt(ctx);
        } else if (ctx.T_MIN_PART_INT() != null) {
            this.execMinPartInt(ctx);
        } else if (ctx.T_MAX_PART_DATE() != null) {
            this.execMaxPartDate(ctx);
        } else if (ctx.T_MIN_PART_DATE() != null) {
            this.execMinPartDate(ctx);
        } else if (ctx.T_PART_LOC() != null) {
            this.execPartLoc(ctx);
        } else if (this.exec.buildSql) {
            this.exec.stackPush(Exec.getFormattedText(ctx));
        } else {
            this.evalNull();
        }
    }

    public void specExecSql(HplsqlParser.Expr_spec_funcContext ctx) {
        FuncSpecCommand func;
        String name = ctx.start.getText().toUpperCase();
        if (this.trace && ctx.parent.parent instanceof HplsqlParser.Expr_stmtContext) {
            this.trace(ctx, "FUNC " + name);
        }
        if ((func = this.specSqlMap.get(name)) != null) {
            func.run(ctx);
        } else {
            this.specExec(ctx);
        }
    }

    public void execCurrentDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "CURRENT_DATE");
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String s = f.format(Calendar.getInstance().getTime());
        this.exec.stackPush(new Var(Var.Type.DATE, Utils.toDate(s)));
    }

    public void execMaxPartString(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_STRING");
        }
        this.execMinMaxPart(ctx, Var.Type.STRING, true);
    }

    public void execMinPartString(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_STRING");
        }
        this.execMinMaxPart(ctx, Var.Type.STRING, false);
    }

    public void execMaxPartInt(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_INT");
        }
        this.execMinMaxPart(ctx, Var.Type.BIGINT, true);
    }

    public void execMinPartInt(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_INT");
        }
        this.execMinMaxPart(ctx, Var.Type.BIGINT, false);
    }

    public void execMaxPartDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MAX_PART_DATE");
        }
        this.execMinMaxPart(ctx, Var.Type.DATE, true);
    }

    public void execMinPartDate(HplsqlParser.Expr_spec_funcContext ctx) {
        if (this.trace) {
            this.trace(ctx, "MIN_PART_DATE");
        }
        this.execMinMaxPart(ctx, Var.Type.DATE, false);
    }

    public void execMinMaxPart(HplsqlParser.Expr_spec_funcContext ctx, Var.Type type, boolean max) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        StringBuilder sql = new StringBuilder("SHOW PARTITIONS " + tabname);
        String colname = null;
        int colnum = -1;
        int exprnum = ctx.expr().size();
        if (ctx.expr(1) != null) {
            colname = this.evalPop(ctx.expr(1)).toString();
        } else {
            colnum = 0;
        }
        if (exprnum >= 4) {
            sql.append(" PARTITION (");
            int i = 2;
            while (i + 1 < exprnum) {
                String fcol = this.evalPop(ctx.expr(i)).toString();
                String fval = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql.append(", ");
                }
                sql.append(fcol).append("=").append(fval);
                i += 2;
            }
            sql.append(")");
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        QueryResult query = this.queryExecutor.executeQuery(sql.toString(), ctx);
        if (query.error()) {
            this.evalNullClose(query);
            return;
        }
        try {
            String resultString = null;
            Long resultInt = null;
            Date resultDate = null;
            while (query.next()) {
                String[] parts = query.column(0, String.class).split("/");
                if (colnum == -1) {
                    for (int i = 0; i < parts.length; ++i) {
                        String[] name = parts[i].split("=");
                        if (!name[0].equalsIgnoreCase(colname)) continue;
                        colnum = i;
                        break;
                    }
                    if (colnum == -1) {
                        this.evalNullClose(query);
                        return;
                    }
                }
                String[] pair = parts[colnum].split("=");
                if (type == Var.Type.STRING) {
                    resultString = Utils.minMaxString(resultString, pair[1], max);
                    continue;
                }
                if (type == Var.Type.BIGINT) {
                    resultInt = Utils.minMaxInt(resultInt, pair[1], max);
                    continue;
                }
                if (type != Var.Type.DATE) continue;
                resultDate = Utils.minMaxDate(resultDate, pair[1], max);
            }
            if (resultString != null) {
                this.evalString(resultString);
            } else if (resultInt != null) {
                this.evalInt(resultInt);
            } else if (resultDate != null) {
                this.evalDate(resultDate);
            } else {
                this.evalNull();
            }
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        query.close();
    }

    public void execPartLoc(HplsqlParser.Expr_spec_funcContext ctx) {
        String tabname = this.evalPop(ctx.expr(0)).toString();
        StringBuilder sql = new StringBuilder("DESCRIBE EXTENDED " + tabname);
        int exprnum = ctx.expr().size();
        boolean hostname = false;
        if (exprnum > 1) {
            sql.append(" PARTITION (");
            int i = 1;
            while (i + 1 < exprnum) {
                String col = this.evalPop(ctx.expr(i)).toString();
                String val = this.evalPop(ctx.expr(i + 1)).toSqlString();
                if (i > 2) {
                    sql.append(", ");
                }
                sql.append(col).append("=").append(val);
                i += 2;
            }
            sql.append(")");
        }
        if (exprnum % 2 == 0 && this.evalPop(ctx.expr(exprnum - 1)).intValue() == 1) {
            hostname = true;
        }
        if (this.trace) {
            this.trace(ctx, "Query: " + sql);
        }
        if (this.exec.getOffline()) {
            this.evalNull();
            return;
        }
        QueryResult query = this.queryExecutor.executeQuery(sql.toString(), ctx);
        if (query.error()) {
            this.evalNullClose(query);
            return;
        }
        String result = null;
        try {
            while (query.next()) {
                Matcher m;
                if (!query.column(0, String.class).startsWith("Detailed Partition Information") || !(m = Pattern.compile(".*, location:(.*?),.*").matcher(query.column(1, String.class))).find()) continue;
                result = m.group(1);
            }
        }
        catch (QueryException m) {
            // empty catch block
        }
        if (result != null) {
            if (!hostname && (m = Pattern.compile(".*://.*?(/.*)").matcher(result)).find()) {
                result = m.group(1);
            }
            this.evalString(result);
        } else {
            this.evalNull();
        }
        query.close();
    }

    public void trace(ParserRuleContext ctx, String message) {
        if (this.trace) {
            this.exec.trace(ctx, message);
        }
    }

    protected void evalNull() {
        this.exec.stackPush(Var.Null);
    }

    protected void evalString(String string) {
        this.exec.stackPush(new Var(string));
    }

    protected void evalSqlString(String string) {
        this.exec.stackPush(new Var(Var.Type.SQL_STRING, (Object)string));
    }

    protected Var evalPop(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
        return this.exec.stackPop();
    }

    protected void evalInt(Long i) {
        this.exec.stackPush(new Var(i));
    }

    protected void evalDate(Date date) {
        this.exec.stackPush(new Var(Var.Type.DATE, date));
    }

    protected void evalNullClose(QueryResult query) {
        this.exec.stackPush(Var.Null);
        query.close();
        if (this.trace) {
            query.printStackTrace();
        }
    }

    protected void evalVar(Var var) {
        this.exec.stackPush(var);
    }

    protected void evalString(StringBuilder string) {
        this.evalString(string.toString());
    }

    protected void evalInt(int i) {
        this.evalInt(Long.valueOf(i));
    }

    protected Var evalPop(ParserRuleContext ctx, int value) {
        if (ctx != null) {
            return this.evalPop(ctx);
        }
        return new Var(Long.valueOf(value));
    }

    public static int getParamCount(HplsqlParser.Expr_func_paramsContext ctx) {
        if (ctx == null) {
            return 0;
        }
        return ctx.func_param().size();
    }

    protected void eval(ParserRuleContext ctx) {
        this.exec.visit((ParseTree)ctx);
    }

    protected Integer visit(ParserRuleContext ctx) {
        return (Integer)this.exec.visit((ParseTree)ctx);
    }

    protected void info(ParserRuleContext ctx, String message) {
        this.exec.info(ctx, message);
    }
}

