/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateUtils;

@Description(name="add_months", value="_FUNC_(start_date, num_months, output_date_format) - Returns the date that is num_months after start_date.", extended="start_date is a string or timestamp indicating a valid date. num_months is a number. output_date_format is an optional String which specifies the format for output.\nThe default output format is 'YYYY-MM-dd'.\nExample:\n  > SELECT _FUNC_('2009-08-31', 1) FROM src LIMIT 1;\n '2009-09-30'.\n  > SELECT _FUNC_('2017-12-31 14:15:16', 2, 'YYYY-MM-dd HH:mm:ss') LIMIT 1;\n'2018-02-28 14:15:16'.\n")
@NDV(maxNdv=250L)
public class GenericUDFAddMonths
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] tsConverters = new ObjectInspectorConverters.Converter[3];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[3];
    private transient ObjectInspectorConverters.Converter[] dtConverters = new ObjectInspectorConverters.Converter[3];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] dtInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[3];
    private final Text output = new Text();
    private transient SimpleDateFormat formatter = null;
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private transient Integer numMonthsConst;
    private transient boolean isNumMonthsConst;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 3);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        if (arguments.length == 3) {
            if (arguments[2] instanceof ConstantObjectInspector) {
                this.checkArgPrimitive(arguments, 2);
                this.checkArgGroups(arguments, 2, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP);
                String fmtStr = this.getConstantStringValue(arguments, 2);
                if (fmtStr != null) {
                    this.formatter = new SimpleDateFormat(fmtStr);
                    this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                }
            } else {
                throw new UDFArgumentTypeException(2, this.getFuncName() + " only takes constant as " + this.getArgOrder(2) + " argument");
            }
        }
        if (this.formatter == null) {
            this.formatter = DateUtils.getDateFormat();
        }
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 0, this.dtInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConverters);
        this.obtainDateConverter(arguments, 0, this.dtInputTypes, this.dtConverters);
        this.checkArgGroups(arguments, 1, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainIntConverter(arguments, 1, this.tsInputTypes, this.tsConverters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            this.numMonthsConst = this.getConstantIntValue(arguments, 1);
            this.isNumMonthsConst = true;
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Integer numMonthV = this.isNumMonthsConst ? this.numMonthsConst : this.getIntValue(arguments, 1, this.tsConverters);
        if (numMonthV == null) {
            return null;
        }
        int numMonthInt = numMonthV;
        Timestamp ts = this.getTimestampValue(arguments, 0, this.tsConverters);
        if (ts != null) {
            this.addMonth(ts, numMonthInt);
        } else {
            Date date = this.getDateValue(arguments, 0, this.dtInputTypes, this.dtConverters);
            if (date != null) {
                this.addMonth(date, numMonthInt);
            } else {
                return null;
            }
        }
        String res = this.formatter.format(this.calendar.getTime());
        this.output.set(res);
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "add_months";
    }

    private Calendar addMonth(Date d, int numMonths) {
        this.calendar.setTimeInMillis(d.toEpochMilli());
        return this.addMonth(numMonths);
    }

    private Calendar addMonth(Timestamp ts, int numMonths) {
        this.calendar.setTimeInMillis(ts.toEpochMilli());
        return this.addMonth(numMonths);
    }

    private Calendar addMonth(int numMonths) {
        boolean lastDatOfMonth = this.isLastDayOfMonth(this.calendar);
        this.calendar.add(2, numMonths);
        if (lastDatOfMonth) {
            int maxDd = this.calendar.getActualMaximum(5);
            this.calendar.set(5, maxDd);
        }
        return this.calendar;
    }

    private boolean isLastDayOfMonth(Calendar cal) {
        int maxDd = cal.getActualMaximum(5);
        int dd = cal.get(5);
        return dd == maxDd;
    }
}

