/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.hive.com.google.common.collect.ImmutableList;

public class RexWindow {
    public final ImmutableList<RexNode> partitionKeys;
    public final ImmutableList<RexFieldCollation> orderKeys;
    private final RexWindowBound lowerBound;
    private final RexWindowBound upperBound;
    private final boolean isRows;
    private final String digest;

    RexWindow(List<RexNode> partitionKeys, List<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean isRows) {
        assert (partitionKeys != null);
        assert (orderKeys != null);
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.orderKeys = ImmutableList.copyOf(orderKeys);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.isRows = isRows;
        this.digest = this.computeDigest();
    }

    public String toString() {
        return this.digest;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(Object that) {
        if (that instanceof RexWindow) {
            RexWindow window = (RexWindow)that;
            return this.digest.equals(window.digest);
        }
        return false;
    }

    private String computeDigest() {
        int i;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int clauseCount = 0;
        if (this.partitionKeys.size() > 0) {
            if (clauseCount++ > 0) {
                pw.print(' ');
            }
            pw.print("PARTITION BY ");
            for (i = 0; i < this.partitionKeys.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                RexNode partitionKey = (RexNode)this.partitionKeys.get(i);
                pw.print(partitionKey.toString());
            }
        }
        if (this.orderKeys.size() > 0) {
            if (clauseCount++ > 0) {
                pw.print(' ');
            }
            pw.print("ORDER BY ");
            for (i = 0; i < this.orderKeys.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                RexFieldCollation orderKey = (RexFieldCollation)this.orderKeys.get(i);
                pw.print(orderKey.toString());
            }
        }
        if (this.lowerBound != null) {
            if (this.upperBound == null) {
                if (clauseCount++ > 0) {
                    pw.print(' ');
                }
                if (this.isRows) {
                    pw.print("ROWS ");
                } else {
                    pw.print("RANGE ");
                }
                pw.print(this.lowerBound.toString());
            } else {
                if (clauseCount++ > 0) {
                    pw.print(' ');
                }
                if (this.isRows) {
                    pw.print("ROWS BETWEEN ");
                } else {
                    pw.print("RANGE BETWEEN ");
                }
                pw.print(this.lowerBound.toString());
                pw.print(" AND ");
                pw.print(this.upperBound.toString());
            }
        }
        return sw.toString();
    }

    public RexWindowBound getLowerBound() {
        return this.lowerBound;
    }

    public RexWindowBound getUpperBound() {
        return this.upperBound;
    }

    public boolean isRows() {
        return this.isRows;
    }
}

