/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.BloomFilter;

public class VectorUDAFBloomFilterMerge
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private long expectedEntries = -1L;
    private transient int aggBufferSize = -1;
    private transient BytesWritable bw = new BytesWritable();

    @Override
    public VectorExpression inputExpression() {
        return this.inputExpression;
    }

    public VectorUDAFBloomFilterMerge(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFBloomFilterMerge() {
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        if (this.expectedEntries < 0L) {
            throw new IllegalStateException("expectedEntries not initialized");
        }
        return new Aggregation(this.expectedEntries);
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColumn.isRepeating) {
            if (inputColumn.noNulls) {
                this.processValue(myagg, inputColumn, 0);
            }
            return;
        }
        if (!batch.selectedInUse && inputColumn.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColumn, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColumn, batchSize);
        } else if (inputColumn.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColumn, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColumn, batchSize, batch.selected);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, ColumnVector inputColumn, int batchSize, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (inputColumn.isNull[i]) continue;
            this.processValue(myagg, inputColumn, i);
        }
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        ColumnVector inputColumn = batch.cols[this.inputExpression.getOutputColumn()];
        if (inputColumn.noNulls) {
            if (inputColumn.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        } else if (!inputColumn.isRepeating) {
            if (batch.selectedInUse) {
                this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize, batch.selected);
            } else {
                this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColumn, batchSize);
            }
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.processValue(myagg, inputColumn, 0);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.processValue(myagg, inputColumn, row);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize, int[] selection) {
        for (int i = 0; i < batchSize; ++i) {
            int row = selection[i];
            if (inputColumn.isNull[row]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, ColumnVector inputColumn, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            if (inputColumn.isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregrateIndex, i);
            this.processValue(myagg, inputColumn, i);
        }
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregrateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregrateIndex);
        return myagg;
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        agg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation bfAgg = (Aggregation)agg;
        this.bw.set(bfAgg.bfBytes, 0, bfAgg.bfBytes.length);
        return this.bw;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        if (this.aggBufferSize < 0) {
            try {
                Aggregation agg = (Aggregation)this.getNewAggregationBuffer();
                this.aggBufferSize = agg.bfBytes.length;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error while creating AggregationBuffer", e);
            }
        }
        return this.aggBufferSize;
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
        GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator udafBloomFilter = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)desc.getGenericUDAFEvaluator();
        this.expectedEntries = udafBloomFilter.getExpectedEntries();
    }

    void processValue(Aggregation myagg, ColumnVector columnVector, int i) {
        BytesColumnVector inputColumn = (BytesColumnVector)columnVector;
        BloomFilter.mergeBloomFilterBytes(myagg.bfBytes, 0, myagg.bfBytes.length, inputColumn.vector[i], inputColumn.start[i], inputColumn.length[i]);
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        byte[] bfBytes;

        public Aggregation(long expectedEntries) {
            try {
                BloomFilter bf = new BloomFilter(expectedEntries);
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                BloomFilter.serialize(bytesOut, bf);
                this.bfBytes = bytesOut.toByteArray();
            }
            catch (Exception err) {
                throw new IllegalArgumentException("Error creating aggregation buffer", err);
            }
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            Arrays.fill(this.bfBytes, 5, this.bfBytes.length, (byte)0);
        }
    }
}

