/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlKind;

public abstract class SetOp
extends AbstractRelNode {
    protected ImmutableList<RelNode> inputs;
    public final SqlKind kind;
    public final boolean all;

    protected SetOp(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, SqlKind kind, boolean all) {
        super(cluster, traits);
        Preconditions.checkArgument(kind == SqlKind.UNION || kind == SqlKind.INTERSECT || kind == SqlKind.EXCEPT);
        this.kind = kind;
        this.inputs = ImmutableList.copyOf(inputs);
        this.all = all;
    }

    protected SetOp(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInputs(), SqlKind.UNION, input.getBoolean("all", false));
    }

    public abstract SetOp copy(RelTraitSet var1, List<RelNode> var2, boolean var3);

    @Override
    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, inputs, this.all);
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(this.inputs);
        newInputs.set(ordinalInParent, p);
        this.inputs = ImmutableList.copyOf(newInputs);
        this.recomputeDigest();
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord<RelNode> ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        return pw.item("all", this.all);
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                return ((RelNode)SetOp.this.inputs.get(index)).getRowType();
            }

            @Override
            public int size() {
                return SetOp.this.inputs.size();
            }
        });
    }

    public boolean isHomogeneous(boolean compareNames) {
        RelDataType unionType = this.getRowType();
        for (RelNode input : this.getInputs()) {
            if (RelOptUtil.areRowTypesEqual(input.getRowType(), unionType, compareNames)) continue;
            return false;
        }
        return true;
    }
}

