/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.IFileInputStream;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.security.IntermediateEncryptedStream;
import org.apache.hadoop.mapreduce.task.reduce.IFileWrappedMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.MapHost;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class OnDiskMapOutput<K, V>
extends IFileWrappedMapOutput<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(OnDiskMapOutput.class);
    private final FileSystem fs;
    private final Path tmpOutputPath;
    private final Path outputPath;
    private final OutputStream disk;
    private long compressedSize;

    @Deprecated
    public OnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, MergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput) throws IOException {
        this(mapId, merger, size, conf, fetcher, primaryMapOutput, FileSystem.getLocal(conf).getRaw(), mapOutputFile.getInputFileForWrite(mapId.getTaskID(), size));
    }

    @Deprecated
    OnDiskMapOutput(TaskAttemptID mapId, TaskAttemptID reduceId, MergeManagerImpl<K, V> merger, long size, JobConf conf, MapOutputFile mapOutputFile, int fetcher, boolean primaryMapOutput, FileSystem fs, Path outputPath) throws IOException {
        this(mapId, merger, size, conf, fetcher, primaryMapOutput, fs, outputPath);
    }

    OnDiskMapOutput(TaskAttemptID mapId, MergeManagerImpl<K, V> merger, long size, JobConf conf, int fetcher, boolean primaryMapOutput, FileSystem fs, Path outputPath) throws IOException {
        super(conf, merger, mapId, size, primaryMapOutput);
        this.fs = fs;
        this.outputPath = outputPath;
        this.tmpOutputPath = OnDiskMapOutput.getTempPath(outputPath, fetcher);
        this.disk = IntermediateEncryptedStream.wrapIfNecessary((Configuration)conf, fs.create(this.tmpOutputPath), this.tmpOutputPath);
    }

    @VisibleForTesting
    static Path getTempPath(Path outPath, int fetcher) {
        return outPath.suffix(String.valueOf(fetcher));
    }

    @Override
    protected void doShuffle(MapHost host, IFileInputStream input, long compressedLength, long decompressedLength, ShuffleClientMetrics metrics, Reporter reporter) throws IOException {
        long bytesLeft;
        try {
            int n;
            int BYTES_TO_READ = 65536;
            byte[] buf = new byte[65536];
            for (bytesLeft = compressedLength; bytesLeft > 0L; bytesLeft -= (long)n) {
                n = input.readWithChecksum(buf, 0, (int)Math.min(bytesLeft, 65536L));
                if (n < 0) {
                    throw new IOException("read past end of stream reading " + this.getMapId());
                }
                this.disk.write(buf, 0, n);
                metrics.inputBytes(n);
                reporter.progress();
            }
            LOG.info("Read " + (compressedLength - bytesLeft) + " bytes from map-output for " + this.getMapId());
            this.disk.close();
        }
        catch (IOException ioe) {
            IOUtils.cleanupWithLogger(LOG, this.disk);
            throw ioe;
        }
        if (bytesLeft != 0L) {
            throw new IOException("Incomplete map output received for " + this.getMapId() + " from " + host.getHostName() + " (" + bytesLeft + " bytes missing of " + compressedLength + ")");
        }
        this.compressedSize = compressedLength;
    }

    @Override
    public void commit() throws IOException {
        this.fs.rename(this.tmpOutputPath, this.outputPath);
        MergeManagerImpl.CompressAwarePath compressAwarePath = new MergeManagerImpl.CompressAwarePath(this.outputPath, this.getSize(), this.compressedSize);
        this.getMerger().closeOnDiskFile(compressAwarePath);
    }

    @Override
    public void abort() {
        try {
            this.fs.delete(this.tmpOutputPath, false);
        }
        catch (IOException ie) {
            LOG.info("failure to clean up " + this.tmpOutputPath, (Throwable)ie);
        }
    }

    @Override
    public String getDescription() {
        return "DISK";
    }
}

