/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.api.OverWindowRange;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.expressions.TimePointUnit;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;

@PublicEvolving
public final class Expressions {
    public static final ApiExpression UNBOUNDED_ROW = Expressions.lit(OverWindowRange.UNBOUNDED_ROW);
    public static final ApiExpression UNBOUNDED_RANGE = Expressions.lit(OverWindowRange.UNBOUNDED_RANGE);
    public static final ApiExpression CURRENT_ROW = Expressions.lit(OverWindowRange.CURRENT_ROW);
    public static final ApiExpression CURRENT_RANGE = Expressions.lit(OverWindowRange.CURRENT_RANGE);

    public static ApiExpression $(String name) {
        return new ApiExpression(ApiExpressionUtils.unresolvedRef(name));
    }

    public static ApiExpression col(String name) {
        return Expressions.$(name);
    }

    public static ApiExpression lit(Object v) {
        return new ApiExpression((Expression)ApiExpressionUtils.valueLiteral(v));
    }

    public static ApiExpression lit(Object v, DataType dataType) {
        return new ApiExpression((Expression)ApiExpressionUtils.valueLiteral(v, dataType));
    }

    public static ApiExpression range(String start, String end) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RANGE_TO, ApiExpressionUtils.unresolvedRef(start), ApiExpressionUtils.unresolvedRef(end));
    }

    public static ApiExpression range(int start, int end) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RANGE_TO, ApiExpressionUtils.valueLiteral(start), ApiExpressionUtils.valueLiteral(end));
    }

    public static ApiExpression and(Object predicate0, Object predicate1, Object ... predicates) {
        return Expressions.apiCallAtLeastTwoArgument((FunctionDefinition)BuiltInFunctionDefinitions.AND, predicate0, predicate1, predicates);
    }

    public static ApiExpression or(Object predicate0, Object predicate1, Object ... predicates) {
        return Expressions.apiCallAtLeastTwoArgument((FunctionDefinition)BuiltInFunctionDefinitions.OR, predicate0, predicate1, predicates);
    }

    public static ApiExpression not(Object expression) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.NOT, expression);
    }

    public static ApiExpression currentDate() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_DATE, new Object[0]);
    }

    public static ApiExpression currentTime() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIME, new Object[0]);
    }

    public static ApiExpression currentTimestamp() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_TIMESTAMP, new Object[0]);
    }

    public static ApiExpression currentWatermark(Object rowtimeAttribute) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_WATERMARK, rowtimeAttribute);
    }

    public static ApiExpression currentDatabase() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CURRENT_DATABASE, new Object[0]);
    }

    public static ApiExpression localTime() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIME, new Object[0]);
    }

    public static ApiExpression localTimestamp() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LOCAL_TIMESTAMP, new Object[0]);
    }

    public static ApiExpression toDate(Object dateStr) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_DATE, dateStr);
    }

    public static ApiExpression toDate(Object dateStr, Object format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_DATE, dateStr, format);
    }

    public static ApiExpression toTimestamp(Object timestampStr) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP, timestampStr);
    }

    public static ApiExpression toTimestamp(Object timestampStr, Object format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP, timestampStr, format);
    }

    public static ApiExpression toTimestampLtz(Object numericEpochTime, Object precision) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, numericEpochTime, precision);
    }

    public static ApiExpression toTimestampLtz(String timestampStr, String format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, timestampStr, format);
    }

    public static ApiExpression toTimestampLtz(String timeStamp) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, timeStamp);
    }

    public static ApiExpression toTimestampLtz(Object numericEpochTime) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, numericEpochTime);
    }

    public static ApiExpression toTimestampLtz(Object timestampStr, Object format, Object timezone) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TO_TIMESTAMP_LTZ, timestampStr, format, timezone);
    }

    public static ApiExpression temporalOverlaps(Object leftTimePoint, Object leftTemporal, Object rightTimePoint, Object rightTemporal) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TEMPORAL_OVERLAPS, leftTimePoint, leftTemporal, rightTimePoint, rightTemporal);
    }

    public static ApiExpression dateFormat(Object timestamp, Object format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.DATE_FORMAT, timestamp, format);
    }

    public static ApiExpression timestampDiff(TimePointUnit timePointUnit, Object timePoint1, Object timePoint2) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.TIMESTAMP_DIFF, ApiExpressionUtils.valueLiteral(timePointUnit), timePoint1, timePoint2);
    }

    public static ApiExpression convertTz(Object dateStr, Object tzFrom, Object tzTo) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.CONVERT_TZ, dateStr, tzFrom, tzTo);
    }

    public static ApiExpression fromUnixtime(Object unixtime) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.FROM_UNIXTIME, unixtime);
    }

    public static ApiExpression fromUnixtime(Object unixtime, Object format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.FROM_UNIXTIME, unixtime, format);
    }

    public static ApiExpression unixTimestamp() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.UNIX_TIMESTAMP, new Object[0]);
    }

    public static ApiExpression unixTimestamp(Object timestampStr) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.UNIX_TIMESTAMP, timestampStr);
    }

    public static ApiExpression unixTimestamp(Object timestampStr, Object format) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.UNIX_TIMESTAMP, timestampStr, format);
    }

    public static ApiExpression array(Object head, Object ... tail) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.ARRAY, head, tail);
    }

    public static ApiExpression row(Object head, Object ... tail) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.ROW, head, tail);
    }

    public static ApiExpression map(Object key, Object value, Object ... tail) {
        return Expressions.apiCallAtLeastTwoArgument((FunctionDefinition)BuiltInFunctionDefinitions.MAP, key, value, tail);
    }

    public static ApiExpression mapFromArrays(Object key, Object value) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.MAP_FROM_ARRAYS, ApiExpressionUtils.objectToExpression(key), ApiExpressionUtils.objectToExpression(value));
    }

    public static ApiExpression rowInterval(Long rows) {
        return new ApiExpression((Expression)ApiExpressionUtils.valueLiteral(rows));
    }

    public static ApiExpression pi() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.PI, new Object[0]);
    }

    public static ApiExpression e() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.E, new Object[0]);
    }

    public static ApiExpression rand() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RAND, new Object[0]);
    }

    public static ApiExpression rand(Object seed) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RAND, ApiExpressionUtils.objectToExpression(seed));
    }

    public static ApiExpression randInteger(Object bound) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RAND_INTEGER, ApiExpressionUtils.objectToExpression(bound));
    }

    public static ApiExpression randInteger(Object seed, Object bound) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.RAND_INTEGER, ApiExpressionUtils.objectToExpression(seed), ApiExpressionUtils.objectToExpression(bound));
    }

    public static ApiExpression concat(Object string, Object ... strings) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT, string, strings);
    }

    public static ApiExpression atan2(Object y, Object x) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.ATAN2, y, x);
    }

    public static ApiExpression negative(Object v) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.MINUS_PREFIX, v);
    }

    public static ApiExpression concatWs(Object separator, Object string, Object ... strings) {
        return Expressions.apiCallAtLeastTwoArgument((FunctionDefinition)BuiltInFunctionDefinitions.CONCAT_WS, separator, string, strings);
    }

    public static ApiExpression uuid() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.UUID, new Object[0]);
    }

    public static ApiExpression nullOf(DataType dataType) {
        return new ApiExpression((Expression)ApiExpressionUtils.valueLiteral(null, dataType));
    }

    public static ApiExpression nullOf(TypeInformation<?> typeInfo) {
        return Expressions.nullOf(TypeConversions.fromLegacyInfoToDataType(typeInfo));
    }

    public static ApiExpression log(Object value) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG, value);
    }

    public static ApiExpression log(Object base, Object value) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LOG, base, value);
    }

    public static ApiExpression sourceWatermark() {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.SOURCE_WATERMARK, new Object[0]);
    }

    public static ApiExpression ifThenElse(Object condition, Object ifTrue, Object ifFalse) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.IF, condition, ifTrue, ifFalse);
    }

    public static ApiExpression coalesce(Object ... args) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.COALESCE, args);
    }

    public static ApiExpression withAllColumns() {
        return Expressions.$("*");
    }

    public static ApiExpression withColumns(Object head, Object ... tail) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.WITH_COLUMNS, head, tail);
    }

    public static ApiExpression withoutColumns(Object head, Object ... tail) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.WITHOUT_COLUMNS, head, tail);
    }

    public static ApiExpression jsonObject(JsonOnNull onNull, Object ... keyValues) {
        Object[] arguments = Stream.concat(Stream.of(onNull), Arrays.stream(keyValues)).toArray(Object[]::new);
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.JSON_OBJECT, arguments);
    }

    public static ApiExpression jsonObjectAgg(JsonOnNull onNull, Object keyExpr, Object valueExpr) {
        BuiltInFunctionDefinition functionDefinition;
        switch (onNull) {
            case ABSENT: {
                functionDefinition = BuiltInFunctionDefinitions.JSON_OBJECTAGG_ABSENT_ON_NULL;
                break;
            }
            default: {
                functionDefinition = BuiltInFunctionDefinitions.JSON_OBJECTAGG_NULL_ON_NULL;
            }
        }
        return Expressions.apiCall((FunctionDefinition)functionDefinition, keyExpr, valueExpr);
    }

    public static ApiExpression jsonString(Object value) {
        return Expressions.apiCallAtLeastOneArgument((FunctionDefinition)BuiltInFunctionDefinitions.JSON_STRING, value, new Object[0]);
    }

    public static ApiExpression jsonArray(JsonOnNull onNull, Object ... values) {
        Object[] arguments = Stream.concat(Stream.of(onNull), Arrays.stream(values)).toArray(Object[]::new);
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.JSON_ARRAY, arguments);
    }

    public static ApiExpression jsonArrayAgg(JsonOnNull onNull, Object itemExpr) {
        BuiltInFunctionDefinition functionDefinition;
        switch (onNull) {
            case NULL: {
                functionDefinition = BuiltInFunctionDefinitions.JSON_ARRAYAGG_NULL_ON_NULL;
                break;
            }
            default: {
                functionDefinition = BuiltInFunctionDefinitions.JSON_ARRAYAGG_ABSENT_ON_NULL;
            }
        }
        return Expressions.apiCall((FunctionDefinition)functionDefinition, itemExpr);
    }

    public static ApiExpression lead(Object value) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LEAD, value);
    }

    public static ApiExpression lead(Object value, Object offset) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LEAD, value, offset);
    }

    public static ApiExpression lead(Object value, Object offset, Object defaultValue) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LEAD, value, offset, defaultValue);
    }

    public static ApiExpression lag(Object value) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LAG, value);
    }

    public static ApiExpression lag(Object value, Object offset) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LAG, value, offset);
    }

    public static ApiExpression lag(Object value, Object offset, Object defaultValue) {
        return Expressions.apiCall((FunctionDefinition)BuiltInFunctionDefinitions.LAG, value, offset, defaultValue);
    }

    public static ApiExpression call(String path, Object ... arguments) {
        return new ApiExpression(ApiExpressionUtils.lookupCall(path, (Expression[])Arrays.stream(arguments).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new)));
    }

    public static ApiExpression call(UserDefinedFunction function, Object ... arguments) {
        return Expressions.apiCall((FunctionDefinition)function, arguments);
    }

    public static ApiExpression call(Class<? extends UserDefinedFunction> function, Object ... arguments) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(function);
        return Expressions.apiCall((FunctionDefinition)functionInstance, arguments);
    }

    public static ApiExpression callSql(String sqlExpression) {
        return Expressions.apiSqlCall(sqlExpression);
    }

    private static ApiExpression apiCall(FunctionDefinition functionDefinition, Object ... args) {
        List<Expression> arguments = Stream.of(args).map(ApiExpressionUtils::objectToExpression).collect(Collectors.toList());
        return new ApiExpression(ApiExpressionUtils.unresolvedCall(functionDefinition, arguments));
    }

    private static ApiExpression apiCallAtLeastOneArgument(FunctionDefinition functionDefinition, Object arg0, Object ... args) {
        List<Expression> arguments = Stream.concat(Stream.of(arg0), Stream.of(args)).map(ApiExpressionUtils::objectToExpression).collect(Collectors.toList());
        return new ApiExpression(ApiExpressionUtils.unresolvedCall(functionDefinition, arguments));
    }

    private static ApiExpression apiCallAtLeastTwoArgument(FunctionDefinition functionDefinition, Object arg0, Object arg1, Object ... args) {
        List<Expression> arguments = Stream.concat(Stream.of(arg0, arg1), Stream.of(args)).map(ApiExpressionUtils::objectToExpression).collect(Collectors.toList());
        return new ApiExpression(ApiExpressionUtils.unresolvedCall(functionDefinition, arguments));
    }

    private static ApiExpression apiSqlCall(String sqlExpression) {
        return new ApiExpression((Expression)new SqlCallExpression(sqlExpression));
    }
}

