/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.imps;

import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.org.apache.curator.framework.imps.CuratorFrameworkState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FailedDeleteManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CuratorFramework client;
    volatile FailedDeleteManagerListener debugListener = null;

    FailedDeleteManager(CuratorFramework client) {
        this.client = client;
    }

    void addFailedDelete(String path) {
        if (this.debugListener != null) {
            this.debugListener.pathAddedForDelete(path);
        }
        if (this.client.getState() == CuratorFrameworkState.STARTED) {
            this.log.debug("Path being added to guaranteed delete set: " + path);
            try {
                ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(path);
            }
            catch (Exception e) {
                this.addFailedDelete(path);
            }
        }
    }

    static interface FailedDeleteManagerListener {
        public void pathAddedForDelete(String var1);
    }
}

