/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static Configuration hdConf = new Configuration();

    public static boolean isSecurityEnabled() {
        UserGroupInformation.setConfiguration((Configuration)hdConf);
        return UserGroupInformation.isSecurityEnabled();
    }

    public static <T> T runSecured(final FlinkSecuredRunner<T> runner) throws Exception {
        UserGroupInformation.setConfiguration((Configuration)hdConf);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (!ugi.hasKerberosCredentials()) {
            LOG.error("Security is enabled but no Kerberos credentials have been found. You may authenticate using the kinit command.");
        }
        return (T)ugi.doAs(new PrivilegedExceptionAction<T>(){

            @Override
            public T run() throws Exception {
                return runner.run();
            }
        });
    }

    private SecurityUtils() {
        throw new RuntimeException();
    }

    public static interface FlinkSecuredRunner<T> {
        public T run() throws Exception;
    }
}

