/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.scope;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.metrics.scope.JobManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.JobManagerScopeFormat;
import org.apache.flink.runtime.metrics.scope.OperatorScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskScopeFormat;
import org.apache.flink.util.Preconditions;

public class ScopeFormats {
    private final JobManagerScopeFormat jobManagerFormat;
    private final JobManagerJobScopeFormat jobManagerJobFormat;
    private final TaskManagerScopeFormat taskManagerFormat;
    private final TaskManagerJobScopeFormat taskManagerJobFormat;
    private final TaskScopeFormat taskFormat;
    private final OperatorScopeFormat operatorFormat;

    public ScopeFormats() {
        this.jobManagerFormat = new JobManagerScopeFormat(ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_COMPONENT);
        this.jobManagerJobFormat = new JobManagerJobScopeFormat(ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP, this.jobManagerFormat);
        this.taskManagerFormat = new TaskManagerScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_COMPONENT);
        this.taskManagerJobFormat = new TaskManagerJobScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP, this.taskManagerFormat);
        this.taskFormat = new TaskScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASK_GROUP, this.taskManagerJobFormat);
        this.operatorFormat = new OperatorScopeFormat(ScopeFormat.DEFAULT_SCOPE_OPERATOR_GROUP, this.taskFormat);
    }

    public ScopeFormats(String jobManagerFormat, String jobManagerJobFormat, String taskManagerFormat, String taskManagerJobFormat, String taskFormat, String operatorFormat) {
        this.jobManagerFormat = new JobManagerScopeFormat(jobManagerFormat);
        this.jobManagerJobFormat = new JobManagerJobScopeFormat(jobManagerJobFormat, this.jobManagerFormat);
        this.taskManagerFormat = new TaskManagerScopeFormat(taskManagerFormat);
        this.taskManagerJobFormat = new TaskManagerJobScopeFormat(taskManagerJobFormat, this.taskManagerFormat);
        this.taskFormat = new TaskScopeFormat(taskFormat, this.taskManagerJobFormat);
        this.operatorFormat = new OperatorScopeFormat(operatorFormat, this.taskFormat);
    }

    public ScopeFormats(JobManagerScopeFormat jobManagerFormat, JobManagerJobScopeFormat jobManagerJobFormat, TaskManagerScopeFormat taskManagerFormat, TaskManagerJobScopeFormat taskManagerJobFormat, TaskScopeFormat taskFormat, OperatorScopeFormat operatorFormat) {
        this.jobManagerFormat = (JobManagerScopeFormat)Preconditions.checkNotNull((Object)jobManagerFormat);
        this.jobManagerJobFormat = (JobManagerJobScopeFormat)Preconditions.checkNotNull((Object)jobManagerJobFormat);
        this.taskManagerFormat = (TaskManagerScopeFormat)Preconditions.checkNotNull((Object)taskManagerFormat);
        this.taskManagerJobFormat = (TaskManagerJobScopeFormat)Preconditions.checkNotNull((Object)taskManagerJobFormat);
        this.taskFormat = (TaskScopeFormat)Preconditions.checkNotNull((Object)taskFormat);
        this.operatorFormat = (OperatorScopeFormat)Preconditions.checkNotNull((Object)operatorFormat);
    }

    public JobManagerScopeFormat getJobManagerFormat() {
        return this.jobManagerFormat;
    }

    public TaskManagerScopeFormat getTaskManagerFormat() {
        return this.taskManagerFormat;
    }

    public TaskManagerJobScopeFormat getTaskManagerJobFormat() {
        return this.taskManagerJobFormat;
    }

    public JobManagerJobScopeFormat getJobManagerJobFormat() {
        return this.jobManagerJobFormat;
    }

    public TaskScopeFormat getTaskFormat() {
        return this.taskFormat;
    }

    public OperatorScopeFormat getOperatorFormat() {
        return this.operatorFormat;
    }

    public static ScopeFormats fromConfig(Configuration config) {
        String jmFormat = config.getString("metrics.scope.jm", ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_GROUP);
        String jmJobFormat = config.getString("metrics.scope.jm.job", ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP);
        String tmFormat = config.getString("metrics.scope.tm", ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_GROUP);
        String tmJobFormat = config.getString("metrics.scope.tm.job", ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP);
        String taskFormat = config.getString("metrics.scope.task", ScopeFormat.DEFAULT_SCOPE_TASK_GROUP);
        String operatorFormat = config.getString("metrics.scope.operator", ScopeFormat.DEFAULT_SCOPE_OPERATOR_GROUP);
        return new ScopeFormats(jmFormat, jmJobFormat, tmFormat, tmJobFormat, taskFormat, operatorFormat);
    }
}

