/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.util.Preconditions;

public class Buffer {
    private final MemorySegment memorySegment;
    private final Object recycleLock = new Object();
    private final BufferRecycler recycler;
    private boolean isBuffer;
    private int referenceCount = 1;
    private int currentSize;

    public Buffer(MemorySegment memorySegment, BufferRecycler recycler) {
        this(memorySegment, recycler, true);
    }

    public Buffer(MemorySegment memorySegment, BufferRecycler recycler, boolean isBuffer) {
        this.memorySegment = (MemorySegment)Preconditions.checkNotNull((Object)memorySegment);
        this.recycler = (BufferRecycler)Preconditions.checkNotNull((Object)recycler);
        this.isBuffer = isBuffer;
        this.currentSize = memorySegment.size();
    }

    public boolean isBuffer() {
        return this.isBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tagAsEvent() {
        Object object = this.recycleLock;
        synchronized (object) {
            this.ensureNotRecycled();
        }
        this.isBuffer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemorySegment getMemorySegment() {
        Object object = this.recycleLock;
        synchronized (object) {
            this.ensureNotRecycled();
            return this.memorySegment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getNioBuffer() {
        Object object = this.recycleLock;
        synchronized (object) {
            this.ensureNotRecycled();
            return this.memorySegment.wrap(0, this.currentSize);
        }
    }

    public BufferRecycler getRecycler() {
        return this.recycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.recycleLock;
        synchronized (object) {
            return this.currentSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int newSize) {
        Object object = this.recycleLock;
        synchronized (object) {
            this.ensureNotRecycled();
            if (newSize < 0 || newSize > this.memorySegment.size()) {
                throw new IllegalArgumentException("Size of buffer must be >= 0 and <= " + this.memorySegment.size() + ", but was " + newSize + ".");
            }
            this.currentSize = newSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.recycleLock;
        synchronized (object) {
            if (--this.referenceCount == 0) {
                this.recycler.recycle(this.memorySegment);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer retain() {
        Object object = this.recycleLock;
        synchronized (object) {
            this.ensureNotRecycled();
            ++this.referenceCount;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecycled() {
        Object object = this.recycleLock;
        synchronized (object) {
            return this.referenceCount == 0;
        }
    }

    private void ensureNotRecycled() {
        Preconditions.checkState((this.referenceCount > 0 ? 1 : 0) != 0, (Object)"Buffer has already been recycled.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.recycleLock;
        synchronized (object) {
            return String.format("Buffer %s [size: %d, reference count: %d]", this.hashCode(), this.currentSize, this.referenceCount);
        }
    }
}

