/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.SynchronousFileIOChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class SynchronousBufferFileReader
extends SynchronousFileIOChannel
implements BufferFileReader {
    private final ByteBuffer header = ByteBuffer.allocateDirect(8);
    private boolean hasReachedEndOfFile;

    public SynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled) throws IOException {
        super(channelID, writeEnabled);
    }

    @Override
    public void readInto(Buffer buffer) throws IOException {
        if (this.fileChannel.size() - this.fileChannel.position() > 0L) {
            this.header.clear();
            this.fileChannel.read(this.header);
            this.header.flip();
            boolean isBuffer = this.header.getInt() == 1;
            int size = this.header.getInt();
            if (size > buffer.getMemorySegment().size()) {
                throw new IllegalStateException("Buffer is too small for data: " + buffer.getMemorySegment().size() + " bytes available, but " + size + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
            }
            buffer.setSize(size);
            this.fileChannel.read(buffer.getNioBuffer());
            if (!isBuffer) {
                buffer.tagAsEvent();
            }
            this.hasReachedEndOfFile = this.fileChannel.size() - this.fileChannel.position() == 0L;
        } else {
            buffer.recycle();
        }
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.fileChannel.position(position);
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile;
    }
}

