/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class InputGateDeploymentDescriptor
implements Serializable {
    private final IntermediateDataSetID consumedResultId;
    private final int consumedSubpartitionIndex;
    private final InputChannelDeploymentDescriptor[] inputChannels;

    public InputGateDeploymentDescriptor(IntermediateDataSetID consumedResultId, int consumedSubpartitionIndex, InputChannelDeploymentDescriptor[] inputChannels) {
        this.consumedResultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)consumedResultId)));
        Preconditions.checkArgument((consumedSubpartitionIndex >= 0 ? 1 : 0) != 0);
        this.consumedSubpartitionIndex = consumedSubpartitionIndex;
        this.inputChannels = (InputChannelDeploymentDescriptor[])Preconditions.checkNotNull((Object)inputChannels);
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public int getConsumedSubpartitionIndex() {
        return this.consumedSubpartitionIndex;
    }

    public InputChannelDeploymentDescriptor[] getInputChannelDeploymentDescriptors() {
        return this.inputChannels;
    }

    public String toString() {
        return String.format("InputGateDeploymentDescriptor [result id: %s, consumed subpartition index: %d, input channels: %s]", this.consumedResultId.toString(), this.consumedSubpartitionIndex, Arrays.toString(this.inputChannels));
    }
}

