/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.api.common.accumulators.Accumulator;

public class StringifiedAccumulatorResult
implements Serializable {
    private static final long serialVersionUID = -4642311296836822611L;
    private final String name;
    private final String type;
    private final String value;

    public StringifiedAccumulatorResult(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static StringifiedAccumulatorResult[] stringifyAccumulatorResults(Map<String, Accumulator<?, ?>> accs) {
        if (accs == null || accs.isEmpty()) {
            return new StringifiedAccumulatorResult[0];
        }
        StringifiedAccumulatorResult[] results = new StringifiedAccumulatorResult[accs.size()];
        int i = 0;
        for (Map.Entry<String, Accumulator<?, ?>> entry : accs.entrySet()) {
            Serializable localValue;
            Accumulator<?, ?> accumulator = entry.getValue();
            StringifiedAccumulatorResult result = accumulator != null ? ((localValue = accumulator.getLocalValue()) != null ? new StringifiedAccumulatorResult(entry.getKey(), accumulator.getClass().getSimpleName(), localValue.toString()) : new StringifiedAccumulatorResult(entry.getKey(), accumulator.getClass().getSimpleName(), "null")) : new StringifiedAccumulatorResult(entry.getKey(), "null", "null");
            results[i++] = result;
        }
        return results;
    }
}

