/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.util.Preconditions;

final class ChannelState {
    private final Map<InputChannelInfo, Integer> sequenceNumberInAnnouncedChannels = new HashMap<InputChannelInfo, Integer>();
    private final Set<InputChannelInfo> blockedChannels = new HashSet<InputChannelInfo>();
    private final CheckpointableInput[] inputs;

    public ChannelState(CheckpointableInput[] inputs) {
        this.inputs = inputs;
    }

    public void blockChannel(InputChannelInfo channelInfo) {
        this.inputs[channelInfo.getGateIdx()].blockConsumption(channelInfo);
        this.blockedChannels.add(channelInfo);
    }

    public void channelFinished(InputChannelInfo channelInfo) {
        this.blockedChannels.remove(channelInfo);
        this.sequenceNumberInAnnouncedChannels.remove(channelInfo);
    }

    public void prioritizeAllAnnouncements() throws IOException {
        for (Map.Entry<InputChannelInfo, Integer> announcedNumberInChannel : this.sequenceNumberInAnnouncedChannels.entrySet()) {
            InputChannelInfo channelInfo = announcedNumberInChannel.getKey();
            this.inputs[channelInfo.getGateIdx()].convertToPriorityEvent(channelInfo.getInputChannelIdx(), announcedNumberInChannel.getValue());
        }
        this.sequenceNumberInAnnouncedChannels.clear();
    }

    public void unblockAllChannels() throws IOException {
        for (InputChannelInfo blockedChannel : this.blockedChannels) {
            this.inputs[blockedChannel.getGateIdx()].resumeConsumption(blockedChannel);
        }
        this.blockedChannels.clear();
    }

    public CheckpointableInput[] getInputs() {
        return this.inputs;
    }

    public void addSeenAnnouncement(InputChannelInfo channelInfo, int sequenceNumber) {
        this.sequenceNumberInAnnouncedChannels.put(channelInfo, sequenceNumber);
    }

    public void removeSeenAnnouncement(InputChannelInfo channelInfo) {
        this.sequenceNumberInAnnouncedChannels.remove(channelInfo);
    }

    public ChannelState emptyState() {
        Preconditions.checkState((boolean)this.blockedChannels.isEmpty(), (String)"We should not reset to an empty state if there are blocked channels: %s", (Object[])new Object[]{this.blockedChannels});
        this.sequenceNumberInAnnouncedChannels.clear();
        return this;
    }
}

