/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.RequestQueue;
import org.apache.flink.runtime.io.disk.iomanager.SeekRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class AsynchronousBufferFileReader
extends AsynchronousFileIOChannel<Buffer, ReadRequest>
implements BufferFileReader {
    private final AtomicBoolean hasReachedEndOfFile = new AtomicBoolean();

    protected AsynchronousBufferFileReader(FileIOChannel.ID channelID, RequestQueue<ReadRequest> requestQueue, RequestDoneCallback<Buffer> callback) throws IOException {
        super(channelID, requestQueue, callback, false);
    }

    @Override
    public void readInto(Buffer buffer) throws IOException {
        this.addRequest(new BufferReadRequest(this, buffer, this.hasReachedEndOfFile));
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.requestQueue.add(new SeekRequest(this, position));
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile.get();
    }
}

