/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferWithIdentity;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndex;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;

public class HsMemoryDataSpiller
implements AutoCloseable {
    private final ExecutorService ioExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("hybrid spiller thread").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE).build());
    private final FileChannel dataFileChannel;
    private long totalBytesWritten;

    public HsMemoryDataSpiller(Path dataFilePath) throws IOException {
        this.dataFileChannel = FileChannel.open(dataFilePath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    public CompletableFuture<List<HsFileDataIndex.SpilledBuffer>> spillAsync(List<BufferWithIdentity> bufferToSpill) {
        CompletableFuture<List<HsFileDataIndex.SpilledBuffer>> spilledFuture = new CompletableFuture<List<HsFileDataIndex.SpilledBuffer>>();
        this.ioExecutor.execute(() -> this.spill(bufferToSpill, spilledFuture));
        return spilledFuture;
    }

    private void spill(List<BufferWithIdentity> toWrite, CompletableFuture<List<HsFileDataIndex.SpilledBuffer>> spilledFuture) {
        try {
            ArrayList<HsFileDataIndex.SpilledBuffer> spilledBuffers = new ArrayList<HsFileDataIndex.SpilledBuffer>();
            long expectedBytes = this.createSpilledBuffersAndGetTotalBytes(toWrite, spilledBuffers);
            this.writeBuffers(toWrite, expectedBytes);
            spilledFuture.complete(spilledBuffers);
        }
        catch (IOException exception) {
            ExceptionUtils.rethrow((Throwable)exception);
        }
    }

    private long createSpilledBuffersAndGetTotalBytes(List<BufferWithIdentity> toWrite, List<HsFileDataIndex.SpilledBuffer> spilledBuffers) {
        long expectedBytes = 0L;
        for (BufferWithIdentity bufferWithIdentity : toWrite) {
            Buffer buffer = bufferWithIdentity.getBuffer();
            int numBytes = buffer.readableBytes() + 8;
            spilledBuffers.add(new HsFileDataIndex.SpilledBuffer(bufferWithIdentity.getChannelIndex(), bufferWithIdentity.getBufferIndex(), this.totalBytesWritten + expectedBytes));
            expectedBytes += (long)numBytes;
        }
        return expectedBytes;
    }

    private void writeBuffers(List<BufferWithIdentity> bufferWithIdentities, long expectedBytes) throws IOException {
        if (bufferWithIdentities.isEmpty()) {
            return;
        }
        ByteBuffer[] bufferWithHeaders = new ByteBuffer[2 * bufferWithIdentities.size()];
        for (int i = 0; i < bufferWithIdentities.size(); ++i) {
            Buffer buffer = bufferWithIdentities.get(i).getBuffer();
            this.setBufferWithHeader(buffer, bufferWithHeaders, 2 * i);
        }
        BufferReaderWriterUtil.writeBuffers(this.dataFileChannel, expectedBytes, bufferWithHeaders);
        this.totalBytesWritten += expectedBytes;
    }

    private void setBufferWithHeader(Buffer buffer, ByteBuffer[] bufferWithHeaders, int index) {
        ByteBuffer header = BufferReaderWriterUtil.allocatedHeaderBuffer();
        BufferReaderWriterUtil.setByteChannelBufferHeader(buffer, header);
        bufferWithHeaders[index] = header;
        bufferWithHeaders[index + 1] = buffer.getNioBufferReadable();
    }

    @Override
    public void close() {
        this.ioExecutor.shutdown();
    }

    public void release() {
        try {
            this.ioExecutor.shutdown();
            if (!this.ioExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                throw new TimeoutException("Shutdown spilling thread timeout.");
            }
            this.dataFileChannel.close();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

