/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.traversals;

import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.IterationNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.util.Visitor;

public class IdAndEstimatesVisitor
implements Visitor<OptimizerNode> {
    private final DataStatistics statistics;
    private int id = 1;

    public IdAndEstimatesVisitor(DataStatistics statistics) {
        this.statistics = statistics;
    }

    public boolean preVisit(OptimizerNode visitable) {
        return visitable.getId() == -1;
    }

    public void postVisit(OptimizerNode visitable) {
        visitable.initId(this.id++);
        for (DagConnection conn : visitable.getIncomingConnections()) {
            conn.initMaxDepth();
        }
        for (DagConnection conn : visitable.getBroadcastConnections()) {
            conn.initMaxDepth();
        }
        visitable.computeOutputEstimates(this.statistics);
        if (visitable instanceof IterationNode) {
            ((IterationNode)((Object)visitable)).acceptForStepFunction(this);
        }
    }
}

