/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ia5StringSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(Ia5StringSyntaxChecker.class);

    public Ia5StringSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.26");
    }

    @Override
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for 'null'");
            return true;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        boolean result = Strings.isIA5String(strValue);
        if (result) {
            LOG.debug("Syntax valid for '{}'", value);
        } else {
            LOG.debug("Syntax invalid for '{}'", value);
        }
        return result;
    }
}

