/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.api;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.daffodil.lib.api.DaffodilConfig;
import org.apache.daffodil.lib.api.DaffodilConfigException;
import org.apache.daffodil.lib.api.DaffodilSchemaSource;
import org.apache.daffodil.lib.api.DaffodilTunables$;
import org.apache.daffodil.lib.api.URISchemaSource$;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.externalvars.Binding$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.DaffodilXMLLoader;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.xml.sax.SAXParseException;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.xml.Elem;
import scala.xml.Node;

public final class DaffodilConfig$ {
    public static DaffodilConfig$ MODULE$;

    static {
        new DaffodilConfig$();
    }

    public DaffodilConfig fromXML(Node xml) {
        Option optBindingsNode = xml.$bslash("externalVariableBindings").headOption();
        Seq extVarBindings = (Seq)optBindingsNode.map((Function1 & Serializable & scala.Serializable)x$1 -> Binding$.MODULE$.getBindings((Node)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Option optTunablesXML = xml.$bslash("tunables").headOption();
        Map tunablesMap = (Map)optTunablesXML.map((Function1 & Serializable & scala.Serializable)x$2 -> DaffodilTunables$.MODULE$.tunablesMap((Node)x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
        return new DaffodilConfig((Seq<Binding>)extVarBindings, (Map<String, String>)tunablesMap);
    }

    public DaffodilConfig fromSchemaSource(DaffodilSchemaSource source) {
        DaffodilConfig daffodilConfig;
        DaffodilXMLLoader loader = new DaffodilXMLLoader();
        try {
            Node node = loader.load(source, (Option<URI>)None$.MODULE$, loader.load$default$3());
            Elem rootElem = (Elem)node;
            String string = rootElem.label();
            String string2 = "dfdlConfig";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                NS nS = NS$.MODULE$.apply(rootElem.namespace());
                NS nS2 = XMLUtils$.MODULE$.EXT_NS_APACHE();
                if (!(nS != null ? !((Object)nS).equals(nS2) : nS2 != null)) {
                    node = loader.load(source, (Option<URI>)new Some((Object)XMLUtils$.MODULE$.dafextURI()), loader.load$default$3());
                }
            }
            daffodilConfig = this.fromXML(node);
        }
        catch (SAXParseException e) {
            throw new DaffodilConfigException(new StringBuilder(30).append("Unable to load configuration: ").append(e).toString(), e);
        }
        return daffodilConfig;
    }

    public DaffodilConfig fromURI(URI uri) {
        return this.fromSchemaSource(URISchemaSource$.MODULE$.apply(Misc$.MODULE$.uriToDiagnosticFile(uri), uri));
    }

    public DaffodilConfig fromFile(File file) {
        return this.fromSchemaSource(URISchemaSource$.MODULE$.apply(file, file.toURI()));
    }

    private DaffodilConfig$() {
        MODULE$ = this;
    }
}

