/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.HintedHandOffManagerMBean;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.gms.FailureDetectorMBean;
import org.apache.cassandra.gms.GossiperMBean;
import org.apache.cassandra.locator.EndpointSnitchInfoMBean;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.metrics.ThreadPoolMetrics;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.CacheServiceMBean;
import org.apache.cassandra.service.GCInspectorMXBean;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamManagerMBean;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.streaming.management.StreamStateCompositeData;
import org.apache.cassandra.tools.BootstrapMonitor;
import org.apache.cassandra.tools.ColumnFamilyStoreMBeanIterator;
import org.apache.cassandra.tools.Output;
import org.apache.cassandra.tools.RepairRunner;

public class NodeProbe
implements AutoCloseable {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://[%s]:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.db:type=StorageService";
    private static final int defaultPort = 7199;
    final String host;
    final int port;
    private String username;
    private String password;
    protected JMXConnector jmxc;
    protected MBeanServerConnection mbeanServerConn;
    protected CompactionManagerMBean compactionProxy;
    protected StorageServiceMBean ssProxy;
    protected GossiperMBean gossProxy;
    protected MemoryMXBean memProxy;
    protected GCInspectorMXBean gcProxy;
    protected RuntimeMXBean runtimeProxy;
    protected StreamManagerMBean streamProxy;
    protected MessagingServiceMBean msProxy;
    protected FailureDetectorMBean fdProxy;
    protected CacheServiceMBean cacheService;
    protected StorageProxyMBean spProxy;
    protected HintedHandOffManagerMBean hhProxy;
    protected Output output;
    private boolean failed;

    public NodeProbe(String host, int port, String username, String password) throws IOException {
        assert (username != null && !username.isEmpty() && password != null && !password.isEmpty()) : "neither username nor password can be blank";
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.output = Output.CONSOLE;
        this.connect();
    }

    public NodeProbe(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.output = Output.CONSOLE;
        this.connect();
    }

    public NodeProbe(String host) throws IOException {
        this.host = host;
        this.port = 7199;
        this.output = Output.CONSOLE;
        this.connect();
    }

    protected NodeProbe() {
        this.host = "";
        this.port = 0;
        this.output = Output.CONSOLE;
    }

    protected void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.username != null) {
            String[] creds = new String[]{this.username, this.password};
            env.put("jmx.remote.credentials", creds);
        }
        env.put("com.sun.jndi.rmi.factory.socket", this.getRMIClientSocketFactory());
        this.jmxc = JMXConnectorFactory.connect(jmxUrl, env);
        this.mbeanServerConn = this.jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=MessagingService");
            this.msProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, MessagingServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=StreamManager");
            this.streamProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StreamManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=CompactionManager");
            this.compactionProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, CompactionManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=FailureDetector");
            this.fdProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, FailureDetectorMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=Caches");
            this.cacheService = JMX.newMBeanProxy(this.mbeanServerConn, name, CacheServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=StorageProxy");
            this.spProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageProxyMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=HintedHandoffManager");
            this.hhProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, HintedHandOffManagerMBean.class);
            name = new ObjectName("org.apache.cassandra.service:type=GCInspector");
            this.gcProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, GCInspectorMXBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=Gossiper");
            this.gossProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, GossiperMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    private RMIClientSocketFactory getRMIClientSocketFactory() throws IOException {
        if (Boolean.parseBoolean(System.getProperty("ssl.enable"))) {
            return new SslRMIClientSocketFactory();
        }
        return RMISocketFactory.getDefaultSocketFactory();
    }

    @Override
    public void close() throws IOException {
        this.jmxc.close();
    }

    public void setOutput(Output output) {
        this.output = output;
    }

    public Output output() {
        return this.output;
    }

    public int forceKeyspaceCleanup(int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.forceKeyspaceCleanup(jobs, keyspaceName, columnFamilies);
    }

    public int scrub(boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTLRows, int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.scrub(disableSnapshot, skipCorrupted, checkData, reinsertOverflowedTTLRows, jobs, keyspaceName, columnFamilies);
    }

    public int verify(boolean extendedVerify, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.verify(extendedVerify, keyspaceName, columnFamilies);
    }

    public int upgradeSSTables(String keyspaceName, boolean excludeCurrentVersion, int jobs, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        return this.ssProxy.upgradeSSTables(keyspaceName, excludeCurrentVersion, jobs, columnFamilies);
    }

    private void checkJobs(PrintStream out, int jobs) {
        if (jobs > DatabaseDescriptor.getConcurrentCompactors()) {
            out.println(String.format("jobs (%d) is bigger than configured concurrent_compactors (%d), using at most %d threads", jobs, DatabaseDescriptor.getConcurrentCompactors(), DatabaseDescriptor.getConcurrentCompactors()));
        }
    }

    public void forceKeyspaceCleanup(PrintStream out, int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        if (this.forceKeyspaceCleanup(jobs, keyspaceName, columnFamilies) != 0) {
            this.failed = true;
            out.println("Aborted cleaning up at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
        }
    }

    public void scrub(PrintStream out, boolean disableSnapshot, boolean skipCorrupted, boolean checkData, boolean reinsertOverflowedTTLRows, int jobs, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        if (this.scrub(disableSnapshot, skipCorrupted, checkData, reinsertOverflowedTTLRows, jobs, keyspaceName, columnFamilies) != 0) {
            this.failed = true;
            out.println("Aborted scrubbing at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
        }
    }

    public void verify(PrintStream out, boolean extendedVerify, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        if (this.verify(extendedVerify, keyspaceName, columnFamilies) != 0) {
            this.failed = true;
            out.println("Aborted verifying at least one table in keyspace " + keyspaceName + ", check server logs for more information.");
        }
    }

    public void upgradeSSTables(PrintStream out, String keyspaceName, boolean excludeCurrentVersion, int jobs, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.checkJobs(out, jobs);
        if (this.upgradeSSTables(keyspaceName, excludeCurrentVersion, jobs, columnFamilies) != 0) {
            this.failed = true;
            out.println("Aborted upgrading sstables for atleast one table in keyspace " + keyspaceName + ", check server logs for more information.");
        }
    }

    public void forceKeyspaceCompaction(boolean splitOutput, String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceKeyspaceCompaction(splitOutput, keyspaceName, columnFamilies);
    }

    public void forceKeyspaceFlush(String keyspaceName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceKeyspaceFlush(keyspaceName, columnFamilies);
    }

    public void repairAsync(PrintStream out, String keyspace, Map<String, String> options) throws IOException {
        RepairRunner runner = new RepairRunner(out, this.ssProxy, keyspace, options);
        try {
            if (this.jmxc != null) {
                this.jmxc.addConnectionNotificationListener(runner, null, null);
            }
            this.ssProxy.addNotificationListener(runner, null, null);
            runner.run();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                this.ssProxy.removeNotificationListener(runner);
                if (this.jmxc != null) {
                    this.jmxc.removeConnectionNotificationListener(runner);
                }
            }
            catch (Throwable e) {
                out.println("Exception occurred during clean-up. " + e);
            }
        }
    }

    public Map<ColumnFamilyMetrics.Sampler, CompositeData> getPartitionSample(String ks, String cf, int capacity, int duration, int count, List<ColumnFamilyMetrics.Sampler> samplers) throws OpenDataException {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        for (ColumnFamilyMetrics.Sampler sampler : samplers) {
            cfsProxy.beginLocalSampling(sampler.name(), capacity);
        }
        Uninterruptibles.sleepUninterruptibly((long)duration, (TimeUnit)TimeUnit.MILLISECONDS);
        HashMap result = Maps.newHashMap();
        for (ColumnFamilyMetrics.Sampler sampler : samplers) {
            result.put(sampler, cfsProxy.finishLocalSampling(sampler.name(), count));
        }
        return result;
    }

    public void invalidateCounterCache() {
        this.cacheService.invalidateCounterCache();
    }

    public void invalidateKeyCache() {
        this.cacheService.invalidateKeyCache();
    }

    public void invalidateRowCache() {
        this.cacheService.invalidateRowCache();
    }

    public void drain() throws IOException, InterruptedException, ExecutionException {
        this.ssProxy.drain();
    }

    public Map<String, String> getTokenToEndpointMap() {
        return this.ssProxy.getTokenToEndpointMap();
    }

    public List<String> getLiveNodes() {
        return this.ssProxy.getLiveNodes();
    }

    public List<String> getJoiningNodes() {
        return this.ssProxy.getJoiningNodes();
    }

    public List<String> getLeavingNodes() {
        return this.ssProxy.getLeavingNodes();
    }

    public List<String> getMovingNodes() {
        return this.ssProxy.getMovingNodes();
    }

    public List<String> getUnreachableNodes() {
        return this.ssProxy.getUnreachableNodes();
    }

    public Map<String, String> getLoadMap() {
        return this.ssProxy.getLoadMap();
    }

    public Map<InetAddress, Float> getOwnership() {
        return this.ssProxy.getOwnership();
    }

    public Map<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        return this.ssProxy.effectiveOwnership(keyspace);
    }

    public CacheServiceMBean getCacheServiceMBean() {
        String cachePath = "org.apache.cassandra.db:type=Caches";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(cachePath), CacheServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public double[] getAndResetGCStats() {
        return this.gcProxy.getAndResetStats();
    }

    public Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> getColumnFamilyStoreMBeanProxies() {
        try {
            return new ColumnFamilyStoreMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public CompactionManagerMBean getCompactionManagerProxy() {
        return this.compactionProxy;
    }

    public List<String> getTokens() {
        return this.ssProxy.getTokens();
    }

    public List<String> getTokens(String endpoint) {
        try {
            return this.ssProxy.getTokens(endpoint);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public String getLocalHostId() {
        return this.ssProxy.getLocalHostId();
    }

    public Map<String, String> getHostIdMap() {
        return this.ssProxy.getEndpointToHostId();
    }

    public String getLoadString() {
        return this.ssProxy.getLoadString();
    }

    public String getReleaseVersion() {
        return this.ssProxy.getReleaseVersion();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public long getUptime() {
        return this.runtimeProxy.getUptime();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memProxy.getHeapMemoryUsage();
    }

    public void takeSnapshot(String snapshotName, String columnFamily, String ... keyspaces) throws IOException {
        if (columnFamily != null) {
            if (keyspaces.length != 1) {
                throw new IOException("When specifying the table for a snapshot, you must specify one and only one keyspace");
            }
            this.ssProxy.takeColumnFamilySnapshot(keyspaces[0], columnFamily, snapshotName);
        } else {
            this.ssProxy.takeSnapshot(snapshotName, keyspaces);
        }
    }

    public void takeMultipleColumnFamilySnapshot(String snapshotName, String ... columnFamilyList) throws IOException {
        if (null == columnFamilyList || columnFamilyList.length == 0) {
            throw new IOException("The column family List  for a snapshot should not be empty or null");
        }
        this.ssProxy.takeMultipleColumnFamilySnapshot(snapshotName, columnFamilyList);
    }

    public void clearSnapshot(String tag, String ... keyspaces) throws IOException {
        this.ssProxy.clearSnapshot(tag, keyspaces);
    }

    public Map<String, TabularData> getSnapshotDetails() {
        return this.ssProxy.getSnapshotDetails();
    }

    public long trueSnapshotsSize() {
        return this.ssProxy.trueSnapshotsSize();
    }

    public boolean isJoined() {
        return this.ssProxy.isJoined();
    }

    public boolean isBootstrapMode() {
        return this.ssProxy.isBootstrapMode();
    }

    public void joinRing() throws IOException {
        this.ssProxy.joinRing();
    }

    public void decommission() throws InterruptedException {
        this.ssProxy.decommission();
    }

    public void move(String newToken) throws IOException {
        this.ssProxy.move(newToken);
    }

    public void removeNode(String token) {
        this.ssProxy.removeNode(token);
    }

    public String getRemovalStatus() {
        return this.ssProxy.getRemovalStatus();
    }

    public void forceRemoveCompletion() {
        this.ssProxy.forceRemoveCompletion();
    }

    public void assassinateEndpoint(String address) throws UnknownHostException {
        this.gossProxy.assassinateEndpoint(address);
    }

    public void setCompactionThreshold(String ks, String cf, int minimumCompactionThreshold, int maximumCompactionThreshold) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        cfsProxy.setCompactionThresholds(minimumCompactionThreshold, maximumCompactionThreshold);
    }

    public void disableAutoCompaction(String ks, String ... columnFamilies) throws IOException {
        this.ssProxy.disableAutoCompaction(ks, columnFamilies);
    }

    public void enableAutoCompaction(String ks, String ... columnFamilies) throws IOException {
        this.ssProxy.enableAutoCompaction(ks, columnFamilies);
    }

    public void setIncrementalBackupsEnabled(boolean enabled) {
        this.ssProxy.setIncrementalBackupsEnabled(enabled);
    }

    public boolean isIncrementalBackupsEnabled() {
        return this.ssProxy.isIncrementalBackupsEnabled();
    }

    public void setCacheCapacities(int keyCacheCapacity, int rowCacheCapacity, int counterCacheCapacity) {
        CacheServiceMBean cacheMBean = this.getCacheServiceMBean();
        cacheMBean.setKeyCacheCapacityInMB(keyCacheCapacity);
        cacheMBean.setRowCacheCapacityInMB(rowCacheCapacity);
        cacheMBean.setCounterCacheCapacityInMB(counterCacheCapacity);
    }

    public void setCacheKeysToSave(int keyCacheKeysToSave, int rowCacheKeysToSave, int counterCacheKeysToSave) {
        CacheServiceMBean cacheMBean = this.getCacheServiceMBean();
        cacheMBean.setKeyCacheKeysToSave(keyCacheKeysToSave);
        cacheMBean.setRowCacheKeysToSave(rowCacheKeysToSave);
        cacheMBean.setCounterCacheKeysToSave(counterCacheKeysToSave);
    }

    public void setHintedHandoffThrottleInKB(int throttleInKB) {
        this.ssProxy.setHintedHandoffThrottleInKB(throttleInKB);
    }

    public List<InetAddress> getEndpoints(String keyspace, String cf, String key) {
        return this.ssProxy.getNaturalEndpoints(keyspace, cf, key);
    }

    public List<String> getSSTables(String keyspace, String cf, String key) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(keyspace, cf);
        return cfsProxy.getSSTablesForKey(key);
    }

    public Set<StreamState> getStreamStatus() {
        return Sets.newHashSet((Iterable)Iterables.transform(this.streamProxy.getCurrentStreams(), (Function)new Function<CompositeData, StreamState>(){

            public StreamState apply(CompositeData input) {
                return StreamStateCompositeData.fromCompositeData(input);
            }
        }));
    }

    public String getOperationMode() {
        return this.ssProxy.getOperationMode();
    }

    public boolean isStarting() {
        return this.ssProxy.isStarting();
    }

    public void truncate(String keyspaceName, String cfName) {
        try {
            this.ssProxy.truncate(keyspaceName, cfName);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
    }

    public EndpointSnitchInfoMBean getEndpointSnitchInfoProxy() {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.db:type=EndpointSnitchInfo"), EndpointSnitchInfoMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnFamilyStoreMBean getCfsProxy(String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = null;
        try {
            String type = cf.contains(".") ? "IndexColumnFamilies" : "ColumnFamilies";
            Set<ObjectName> beans = this.mbeanServerConn.queryNames(new ObjectName("org.apache.cassandra.db:type=*" + type + ",keyspace=" + ks + ",columnfamily=" + cf), null);
            if (beans.isEmpty()) {
                throw new MalformedObjectNameException("couldn't find that bean");
            }
            assert (beans.size() == 1);
            for (ObjectName bean : beans) {
                cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, bean, ColumnFamilyStoreMBean.class);
            }
        }
        catch (MalformedObjectNameException mone) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found: " + e);
            System.exit(1);
        }
        return cfsProxy;
    }

    public StorageProxyMBean getSpProxy() {
        return this.spProxy;
    }

    public StorageServiceMBean getStorageService() {
        return this.ssProxy;
    }

    public GossiperMBean getGossProxy() {
        return this.gossProxy;
    }

    public String getEndpoint() {
        Map<String, String> hostIdToEndpoint = this.ssProxy.getHostIdToEndpoint();
        return hostIdToEndpoint.get(this.ssProxy.getLocalHostId());
    }

    public String getDataCenter() {
        return this.getEndpointSnitchInfoProxy().getDatacenter();
    }

    public String getRack() {
        return this.getEndpointSnitchInfoProxy().getRack();
    }

    public List<String> getKeyspaces() {
        return this.ssProxy.getKeyspaces();
    }

    public List<String> getNonSystemKeyspaces() {
        return this.ssProxy.getNonSystemKeyspaces();
    }

    public String getClusterName() {
        return this.ssProxy.getClusterName();
    }

    public String getPartitioner() {
        return this.ssProxy.getPartitionerName();
    }

    public void disableHintedHandoff() {
        this.spProxy.setHintedHandoffEnabled(false);
    }

    public void enableHintedHandoff() {
        this.spProxy.setHintedHandoffEnabled(true);
    }

    public boolean isHandoffEnabled() {
        return this.spProxy.getHintedHandoffEnabled();
    }

    public void enableHintedHandoff(String dcNames) {
        this.spProxy.setHintedHandoffEnabledByDCList(dcNames);
    }

    public void pauseHintsDelivery() {
        this.hhProxy.pauseHintsDelivery(true);
    }

    public void resumeHintsDelivery() {
        this.hhProxy.pauseHintsDelivery(false);
    }

    public void truncateHints(String host) {
        this.hhProxy.deleteHintsForEndpoint(host);
    }

    public void truncateHints() {
        try {
            this.hhProxy.truncateAllHints();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error while executing truncate hints", e);
        }
    }

    public void refreshSizeEstimates() {
        try {
            this.ssProxy.refreshSizeEstimates();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error while refreshing system.size_estimates", e);
        }
    }

    public void stopNativeTransport() {
        this.ssProxy.stopNativeTransport();
    }

    public void startNativeTransport() {
        this.ssProxy.startNativeTransport();
    }

    public boolean isNativeTransportRunning() {
        return this.ssProxy.isNativeTransportRunning();
    }

    public void stopGossiping() {
        this.ssProxy.stopGossiping();
    }

    public void startGossiping() {
        this.ssProxy.startGossiping();
    }

    public boolean isGossipRunning() {
        return this.ssProxy.isGossipRunning();
    }

    public void stopThriftServer() {
        this.ssProxy.stopRPCServer();
    }

    public void startThriftServer() {
        this.ssProxy.startRPCServer();
    }

    public boolean isThriftServerRunning() {
        return this.ssProxy.isRPCServerRunning();
    }

    public void stopCassandraDaemon() {
        this.ssProxy.stopDaemon();
    }

    public boolean isInitialized() {
        return this.ssProxy.isInitialized();
    }

    public void setCompactionThroughput(int value) {
        this.ssProxy.setCompactionThroughputMbPerSec(value);
    }

    public int getCompactionThroughput() {
        return this.ssProxy.getCompactionThroughputMbPerSec();
    }

    public int getStreamThroughput() {
        return this.ssProxy.getStreamThroughputMbPerSec();
    }

    public int getInterDCStreamThroughput() {
        return this.ssProxy.getInterDCStreamThroughputMbPerSec();
    }

    public double getTraceProbability() {
        return this.ssProxy.getTraceProbability();
    }

    public int getExceptionCount() {
        return (int)StorageMetrics.exceptions.getCount();
    }

    public Map<String, Integer> getDroppedMessages() {
        return this.msProxy.getDroppedMessages();
    }

    public void loadNewSSTables(String ksName, String cfName) {
        this.ssProxy.loadNewSSTables(ksName, cfName);
    }

    public void rebuildIndex(String ksName, String cfName, String ... idxNames) {
        this.ssProxy.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    public String getGossipInfo() {
        return this.fdProxy.getAllEndpointStates();
    }

    public void stop(String string) {
        this.compactionProxy.stopCompaction(string);
    }

    public void stopById(String compactionId) {
        this.compactionProxy.stopCompactionById(compactionId);
    }

    public void setStreamThroughput(int value) {
        this.ssProxy.setStreamThroughputMbPerSec(value);
    }

    public void setInterDCStreamThroughput(int value) {
        this.ssProxy.setInterDCStreamThroughputMbPerSec(value);
    }

    public void setTraceProbability(double value) {
        this.ssProxy.setTraceProbability(value);
    }

    public String getSchemaVersion() {
        return this.ssProxy.getSchemaVersion();
    }

    public List<String> describeRing(String keyspaceName) throws IOException {
        return this.ssProxy.describeRingJMX(keyspaceName);
    }

    public void rebuild(String sourceDc) {
        this.ssProxy.rebuild(sourceDc);
    }

    public List<String> sampleKeyRange() {
        return this.ssProxy.sampleKeyRange();
    }

    public void resetLocalSchema() throws IOException {
        this.ssProxy.resetLocalSchema();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public long getReadRepairAttempted() {
        return this.spProxy.getReadRepairAttempted();
    }

    public long getReadRepairRepairedBlocking() {
        return this.spProxy.getReadRepairRepairedBlocking();
    }

    public long getReadRepairRepairedBackground() {
        return this.spProxy.getReadRepairRepairedBackground();
    }

    public Object getCacheMetric(String cacheType, String metricName) {
        try {
            switch (metricName) {
                case "Capacity": 
                case "Entries": 
                case "HitRate": 
                case "Size": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "Requests": 
                case "Hits": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Cache,scope=" + cacheType + ",name=" + metricName), CassandraMetricsRegistry.JmxMeterMBean.class).getCount();
                }
            }
            throw new RuntimeException("Unknown cache metric name.");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getThreadPoolMetric(String pathName, String poolName, String metricName) {
        return ThreadPoolMetrics.getJmxMetric(this.mbeanServerConn, pathName, poolName, metricName);
    }

    public Multimap<String, String> getThreadPools() {
        return ThreadPoolMetrics.getJmxThreadPools(this.mbeanServerConn);
    }

    public Object getColumnFamilyMetric(String ks, String cf, String metricName) {
        try {
            String type = cf.contains(".") ? "IndexColumnFamily" : "ColumnFamily";
            ObjectName oName = new ObjectName(String.format("org.apache.cassandra.metrics:type=%s,keyspace=%s,scope=%s,name=%s", type, ks, cf, metricName));
            switch (metricName) {
                case "BloomFilterDiskSpaceUsed": 
                case "BloomFilterFalsePositives": 
                case "BloomFilterFalseRatio": 
                case "BloomFilterOffHeapMemoryUsed": 
                case "IndexSummaryOffHeapMemoryUsed": 
                case "CompressionMetadataOffHeapMemoryUsed": 
                case "CompressionRatio": 
                case "EstimatedColumnCountHistogram": 
                case "EstimatedRowSizeHistogram": 
                case "EstimatedRowCount": 
                case "KeyCacheHitRate": 
                case "LiveSSTableCount": 
                case "MaxRowSize": 
                case "MeanRowSize": 
                case "MemtableColumnsCount": 
                case "MemtableLiveDataSize": 
                case "MemtableOffHeapSize": 
                case "MinRowSize": 
                case "RecentBloomFilterFalsePositives": 
                case "RecentBloomFilterFalseRatio": 
                case "SnapshotsSize": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "LiveDiskSpaceUsed": 
                case "MemtableSwitchCount": 
                case "SpeculativeRetries": 
                case "TotalDiskSpaceUsed": 
                case "WriteTotalLatency": 
                case "ReadTotalLatency": 
                case "PendingFlushes": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxCounterMBean.class).getCount();
                }
                case "CoordinatorReadLatency": 
                case "CoordinatorScanLatency": 
                case "ReadLatency": 
                case "WriteLatency": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxTimerMBean.class);
                }
                case "LiveScannedHistogram": 
                case "SSTablesPerReadHistogram": 
                case "TombstoneScannedHistogram": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, oName, CassandraMetricsRegistry.JmxHistogramMBean.class);
                }
            }
            throw new RuntimeException("Unknown table metric.");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public CassandraMetricsRegistry.JmxTimerMBean getProxyMetric(String scope) {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=ClientRequest,scope=" + scope + ",name=Latency"), CassandraMetricsRegistry.JmxTimerMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getCompactionMetric(String metricName) {
        try {
            switch (metricName) {
                case "BytesCompacted": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxCounterMBean.class);
                }
                case "CompletedTasks": 
                case "PendingTasks": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxGaugeMBean.class).getValue();
                }
                case "TotalCompactionsCompleted": {
                    return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Compaction,name=" + metricName), CassandraMetricsRegistry.JmxMeterMBean.class);
                }
            }
            throw new RuntimeException("Unknown compaction metric.");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public long getStorageMetric(String metricName) {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.metrics:type=Storage,name=" + metricName), CassandraMetricsRegistry.JmxCounterMBean.class).getCount();
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public double[] metricPercentilesAsArray(CassandraMetricsRegistry.JmxHistogramMBean metric) {
        return new double[]{metric.get50thPercentile(), metric.get75thPercentile(), metric.get95thPercentile(), metric.get98thPercentile(), metric.get99thPercentile(), metric.getMin(), metric.getMax()};
    }

    public double[] metricPercentilesAsArray(CassandraMetricsRegistry.JmxTimerMBean metric) {
        return new double[]{metric.get50thPercentile(), metric.get75thPercentile(), metric.get95thPercentile(), metric.get98thPercentile(), metric.get99thPercentile(), metric.getMin(), metric.getMax()};
    }

    public TabularData getCompactionHistory() {
        return this.compactionProxy.getCompactionHistory();
    }

    public void reloadTriggers() {
        this.spProxy.reloadTriggerClasses();
    }

    public void setLoggingLevel(String classQualifier, String level) {
        try {
            this.ssProxy.setLoggingLevel(classQualifier, level);
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting log for " + classQualifier + " on level " + level + ". Please check logback configuration and ensure to have <jmxConfigurator /> set", e);
        }
    }

    public Map<String, String> getLoggingLevels() {
        return this.ssProxy.getLoggingLevels();
    }

    public void resumeBootstrap(PrintStream out) throws IOException {
        BootstrapMonitor monitor = new BootstrapMonitor(out);
        try {
            if (this.jmxc != null) {
                this.jmxc.addConnectionNotificationListener(monitor, null, null);
            }
            this.ssProxy.addNotificationListener(monitor, null, null);
            if (this.ssProxy.resumeBootstrap()) {
                out.println("Resuming bootstrap");
                monitor.awaitCompletion();
            } else {
                out.println("Node is already bootstrapped.");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                this.ssProxy.removeNotificationListener(monitor);
                if (this.jmxc != null) {
                    this.jmxc.removeConnectionNotificationListener(monitor);
                }
            }
            catch (Throwable e) {
                out.println("Exception occurred during clean-up. " + e);
            }
        }
    }

    public TabularData getFailureDetectorPhilValues() {
        try {
            return this.fdProxy.getPhiValues();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public MessagingServiceMBean getMessagingServiceProxy() {
        return this.msProxy;
    }
}

