/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

public class OnHierarchicalPropertiesCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnHierarchicalProperties.class.getName());
        ArrayList<String> values = new ArrayList<String>();
        for (AnnotationAttributes attribute : this.annotationAttributesFromMultiValueMap((MultiValueMap<String, Object>)attributes)) {
            String[] vals = (String[])attribute.get((Object)"value");
            if (vals == null) continue;
            values.addAll(Arrays.asList(vals));
        }
        if (values.isEmpty()) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition((String)"no condition", (Object[])new Object[0]).because("no conditions"));
        }
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)((String)values.get(0)), (Object[])new Object[0]);
        Environment environment = context.getEnvironment();
        return HierarchicalPropertiesEvaluator.evaluate(environment, values) ? ConditionOutcome.match((ConditionMessage)message.because("enabled")) : ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
    }

    private List<AnnotationAttributes> annotationAttributesFromMultiValueMap(MultiValueMap<String, Object> multiValueMap) {
        ArrayList maps = new ArrayList();
        multiValueMap.forEach((key, value) -> {
            for (int i = 0; i < value.size(); ++i) {
                Map map;
                if (i < maps.size()) {
                    map = (Map)maps.get(i);
                } else {
                    map = new HashMap();
                    maps.add(map);
                }
                map.put((String)key, value.get(i));
            }
        });
        ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>(maps.size());
        for (Map map : maps) {
            annotationAttributes.add(AnnotationAttributes.fromMap((Map)map));
        }
        return annotationAttributes;
    }
}

