/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation.starter;

import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import org.apache.camel.CamelContext;
import org.apache.camel.observation.MicrometerObservationTracer;
import org.apache.camel.observation.starter.ObservationConfigurationProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.MicrometerTracingAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration.class, MicrometerTracingAutoConfiguration.class})
@EnableConfigurationProperties(value={ObservationConfigurationProperties.class})
@ConditionalOnProperty(value={"camel.observation.enabled"}, matchIfMissing=true)
public class ObservationAutoConfiguration {
    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={MicrometerObservationTracer.class})
    MicrometerObservationTracer micrometerObservationTracer(CamelContext camelContext, ObservationConfigurationProperties config, ObjectProvider<Tracer> tracer, ObjectProvider<ObservationRegistry> observationRegistry) {
        MicrometerObservationTracer micrometerObservationTracer = new MicrometerObservationTracer();
        tracer.ifAvailable(arg_0 -> ((MicrometerObservationTracer)micrometerObservationTracer).setTracer(arg_0));
        observationRegistry.ifAvailable(arg_0 -> ((MicrometerObservationTracer)micrometerObservationTracer).setObservationRegistry(arg_0));
        if (config.getExcludePatterns() != null) {
            micrometerObservationTracer.setExcludePatterns(config.getExcludePatterns());
        }
        if (config.getEncoding() != null) {
            micrometerObservationTracer.setEncoding(config.getEncoding().booleanValue());
        }
        micrometerObservationTracer.init(camelContext);
        return micrometerObservationTracer;
    }
}

