/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.io.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.xml.io.util.XmlStreamReaderException;

public class XmlStreamReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_8 = "UTF-8";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_16 = "UTF-16";
    private static final String CP1047 = "CP1047";
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([.[^; ]]*)");
    private static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);
    private static final MessageFormat RAW_EX_1 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch");
    private static final MessageFormat RAW_EX_2 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM");
    private static final MessageFormat HTTP_EX_1 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL");
    private static final MessageFormat HTTP_EX_2 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch");
    private static final MessageFormat HTTP_EX_3 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME");
    private static String staticDefaultEncoding = null;
    private final String defaultEncoding;
    private Reader reader;
    private String encoding;

    public XmlStreamReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public XmlStreamReader(InputStream is) throws IOException {
        this(is, true);
    }

    public XmlStreamReader(InputStream is, boolean lenient, String defaultEncoding) throws IOException, XmlStreamReaderException {
        this.defaultEncoding = defaultEncoding == null ? staticDefaultEncoding : defaultEncoding;
        try {
            this.doRawStream(is, lenient);
        }
        catch (XmlStreamReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(null, ex);
        }
    }

    public XmlStreamReader(InputStream is, boolean lenient) throws IOException, XmlStreamReaderException {
        this(is, lenient, null);
    }

    public XmlStreamReader(URL url) throws IOException {
        this(url, null);
    }

    public XmlStreamReader(URL url, Map<String, String> requestHeaders) throws IOException {
        this(url.openConnection(), requestHeaders);
    }

    public XmlStreamReader(URLConnection conn) throws IOException {
        this(conn, null);
    }

    public XmlStreamReader(URLConnection conn, Map<String, String> requestHeaders) throws IOException {
        this.defaultEncoding = staticDefaultEncoding;
        boolean lenient = true;
        if (conn instanceof HttpURLConnection) {
            this.setRequestHeader(conn, requestHeaders);
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType(), true);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else if (conn.getContentType() != null) {
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType(), true);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else {
            try {
                this.doRawStream(conn.getInputStream(), true);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(null, ex);
            }
        }
    }

    public XmlStreamReader(InputStream is, String httpContentType) throws IOException {
        this(is, httpContentType, true);
    }

    public XmlStreamReader(InputStream is, String httpContentType, boolean lenient, String defaultEncoding) throws IOException, XmlStreamReaderException {
        this.defaultEncoding = defaultEncoding == null ? staticDefaultEncoding : defaultEncoding;
        try {
            this.doHttpStream(is, httpContentType, lenient);
        }
        catch (XmlStreamReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(httpContentType, ex);
        }
    }

    public XmlStreamReader(InputStream is, String httpContentType, boolean lenient) throws IOException, XmlStreamReaderException {
        this(is, httpContentType, lenient, null);
    }

    public static String getDefaultEncoding() {
        return staticDefaultEncoding;
    }

    public static void setDefaultEncoding(String encoding) {
        staticDefaultEncoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private void doLenientDetection(String httpContentType, XmlStreamReaderException ex) throws IOException {
        if (httpContentType != null && ((String)httpContentType).startsWith("text/html")) {
            httpContentType = ((String)httpContentType).substring("text/html".length());
            httpContentType = "text/xml" + (String)httpContentType;
            try {
                this.doHttpStream(ex.getInputStream(), (String)httpContentType, true);
                ex = null;
            }
            catch (XmlStreamReaderException ex2) {
                ex = ex2;
            }
        }
        if (ex != null) {
            String xmlEncoding = ex.getXmlEncoding();
            if (xmlEncoding == null) {
                xmlEncoding = ex.getContentTypeEncoding();
            }
            if (xmlEncoding == null) {
                xmlEncoding = this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
            }
            this.prepareReader(ex.getInputStream(), xmlEncoding);
        }
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        return this.reader.read(buf, offset, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void doRawStream(InputStream is, boolean lenient) throws IOException {
        BufferedInputStream pis = new BufferedInputStream(is, 4096);
        String bomEnc = XmlStreamReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlStreamReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlStreamReader.getXmlProlog(pis, xmlGuessEnc);
        String calculatedEncoding = this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, pis);
        this.prepareReader(pis, calculatedEncoding);
    }

    private void doHttpStream(InputStream is, String httpContentType, boolean lenient) throws IOException {
        BufferedInputStream pis = new BufferedInputStream(is, 4096);
        String cTMime = XmlStreamReader.getContentTypeMime(httpContentType);
        String cTEnc = XmlStreamReader.getContentTypeEncoding(httpContentType);
        String bomEnc = XmlStreamReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlStreamReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlStreamReader.getXmlProlog(pis, xmlGuessEnc);
        String calculatedHttpEncoding = this.calculateHttpEncoding(cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, pis, lenient);
        this.prepareReader(pis, calculatedHttpEncoding);
    }

    private void prepareReader(InputStream is, String encoding) throws IOException {
        this.reader = new InputStreamReader(is, encoding);
        this.encoding = encoding;
    }

    private String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is) throws IOException {
        String retEncoding;
        if (bomEnc == null) {
            retEncoding = xmlGuessEnc == null || xmlEnc == null ? (this.defaultEncoding == null ? UTF_8 : this.defaultEncoding) : (xmlEnc.equals(UTF_16) && (xmlGuessEnc.equals(UTF_16BE) || xmlGuessEnc.equals(UTF_16LE)) ? xmlGuessEnc : xmlEnc);
        } else if (bomEnc.equals(UTF_8)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            retEncoding = UTF_8;
        } else if (bomEnc.equals(UTF_16BE) || bomEnc.equals(UTF_16LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                throw new IOException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_16) && !xmlEnc.equals(bomEnc)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            retEncoding = bomEnc;
        } else {
            throw new XmlStreamReaderException(RAW_EX_2.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is);
        }
        return retEncoding;
    }

    private void setRequestHeader(URLConnection conn, Map<String, String> requestHeaders) {
        Package pckg = this.getClass().getPackage();
        if (pckg.getImplementationTitle() != null && pckg.getImplementationVersion() != null) {
            conn.setRequestProperty("User-Agent", pckg.getImplementationTitle() + "/" + pckg.getImplementationVersion());
        } else {
            conn.setRequestProperty("User-Agent", "ROME");
        }
        if (requestHeaders != null) {
            for (Map.Entry<String, String> requestHeader : requestHeaders.entrySet()) {
                conn.setRequestProperty(requestHeader.getKey(), requestHeader.getValue());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String calculateHttpEncoding(String cTMime, String cTEnc, String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is, boolean lenient) throws IOException {
        if (lenient && xmlEnc != null) {
            return xmlEnc;
        }
        boolean appXml = XmlStreamReader.isAppXml(cTMime);
        boolean textXml = XmlStreamReader.isTextXml(cTMime);
        if (!appXml && !textXml) throw new XmlStreamReaderException(HTTP_EX_3.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
        if (cTEnc == null) {
            if (appXml) {
                return this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, is);
            }
            if (this.defaultEncoding != null) return this.defaultEncoding;
            return US_ASCII;
        }
        if (bomEnc != null && (cTEnc.equals(UTF_16BE) || cTEnc.equals(UTF_16LE))) {
            throw new XmlStreamReaderException(HTTP_EX_1.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
        }
        if (!cTEnc.equals(UTF_16)) return cTEnc;
        if (bomEnc == null || !bomEnc.startsWith(UTF_16)) throw new XmlStreamReaderException(HTTP_EX_2.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is);
        return bomEnc;
    }

    private static String getContentTypeMime(String httpContentType) {
        String mime = null;
        if (httpContentType != null) {
            int i = httpContentType.indexOf(59);
            mime = i == -1 ? httpContentType.trim() : httpContentType.substring(0, i).trim();
        }
        return mime;
    }

    private static String getContentTypeEncoding(String httpContentType) {
        String encoding = null;
        if (httpContentType != null) {
            int i = httpContentType.indexOf(59);
            if (i > -1) {
                String postMime = httpContentType.substring(i + 1);
                Matcher m = CHARSET_PATTERN.matcher(postMime);
                if (m.find()) {
                    encoding = m.group(1);
                }
                if (encoding != null) {
                    encoding = encoding.toUpperCase(Locale.ENGLISH);
                }
            }
            if (encoding != null && (encoding.startsWith("\"") && encoding.endsWith("\"") || encoding.startsWith("'") && encoding.endsWith("'"))) {
                encoding = encoding.substring(1, encoding.length() - 1);
            }
        }
        return encoding;
    }

    private static String getBOMEncoding(BufferedInputStream is) throws IOException {
        String encoding = null;
        int[] bytes = new int[3];
        is.mark(3);
        bytes[0] = is.read();
        bytes[1] = is.read();
        bytes[2] = is.read();
        if (bytes[0] == 254 && bytes[1] == 255) {
            encoding = UTF_16BE;
            is.reset();
            is.read();
            is.read();
        } else if (bytes[0] == 255 && bytes[1] == 254) {
            encoding = UTF_16LE;
            is.reset();
            is.read();
            is.read();
        } else if (bytes[0] == 239 && bytes[1] == 187 && bytes[2] == 191) {
            encoding = UTF_8;
        } else {
            is.reset();
        }
        return encoding;
    }

    private static String getXMLGuessEncoding(BufferedInputStream is) throws IOException {
        String encoding = null;
        int[] bytes = new int[4];
        is.mark(4);
        bytes[0] = is.read();
        bytes[1] = is.read();
        bytes[2] = is.read();
        bytes[3] = is.read();
        is.reset();
        if (bytes[0] == 0 && bytes[1] == 60 && bytes[2] == 0 && bytes[3] == 63) {
            encoding = UTF_16BE;
        } else if (bytes[0] == 60 && bytes[1] == 0 && bytes[2] == 63 && bytes[3] == 0) {
            encoding = UTF_16LE;
        } else if (bytes[0] == 60 && bytes[1] == 63 && bytes[2] == 120 && bytes[3] == 109) {
            encoding = UTF_8;
        } else if (bytes[0] == 76 && bytes[1] == 111 && bytes[2] == 167 && bytes[3] == 148) {
            encoding = CP1047;
        }
        return encoding;
    }

    static String getXmlProlog(InputStream is, String guessedEnc) throws IOException {
        String encoding = null;
        if (guessedEnc != null) {
            byte[] bytes = new byte[4096];
            is.mark(4096);
            int offset = 0;
            int max = 4096;
            int c = is.read(bytes, offset, max);
            int firstGT = -1;
            while (c != -1 && firstGT == -1 && offset < 4096) {
                c = is.read(bytes, offset += c, max -= c);
                firstGT = new String(bytes, 0, offset, guessedEnc).indexOf(62);
            }
            if (firstGT == -1) {
                if (c == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + offset + " bytes");
            }
            int bytesRead = offset;
            if (bytesRead > 0) {
                is.reset();
                String prolog = new String(bytes, guessedEnc).substring(0, firstGT);
                Matcher m = ENCODING_PATTERN.matcher(prolog);
                if (m.find()) {
                    encoding = m.group(1).toUpperCase(Locale.ENGLISH);
                    encoding = encoding.substring(1, encoding.length() - 1);
                }
            }
        }
        return encoding;
    }

    private static boolean isAppXml(String mime) {
        return mime != null && (mime.equals("application/xml") || mime.equals("application/xml-dtd") || mime.equals("application/xml-external-parsed-entity") || mime.startsWith("application/") && mime.endsWith("+xml"));
    }

    private static boolean isTextXml(String mime) {
        return mime != null && (mime.equals("text/xml") || mime.equals("text/xml-external-parsed-entity") || mime.startsWith("text/") && mime.endsWith("+xml"));
    }
}

