/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.Tag;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class SqlSpanDecorator
extends AbstractSpanDecorator {
    public static final String CAMEL_SQL_QUERY = "CamelSqlQuery";

    @Override
    public String getComponent() {
        return "sql";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.sql.SqlComponent";
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag(Tag.DB_TYPE, "sql");
        Object sqlquery = exchange.getIn().getHeader(CAMEL_SQL_QUERY);
        if (sqlquery instanceof String) {
            span.setTag(Tag.DB_STATEMENT, (String)sqlquery);
        }
    }
}

